﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.DataAccess;
using HCM.BusinessEntities;

namespace HCM.BajaWare.BusinessLogic
{
    public class AvalesLogic
    {
          #region Constructor
        private AvalDataAcces AvalesDA;

        public AvalesLogic()
        {
            AvalesDA = new AvalDataAcces();

        }
        #endregion
        #region Obtiene Datos
        /// <summary>
        /// Obtiene la lista de Avales
        /// </summary>
        /// <param name="iPersona"></param>
        /// <returns></returns>
        public List<Aval> ListadoAccionistas(int Consec)
        {
            List<Aval> results = null;
            try
            {

                results = AvalesDA.ListadoAval(Consec);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        #endregion 

        public ServiceResult InsertarEditar(Aval aval)
        {
            ServiceResult resultado = new ServiceResult();
            try
            {

                resultado.ResultValue = AvalesDA.InsertarEditar(aval);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return resultado;
        }
    }
}
