﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.BusinessEntities;
using HCM.DataAccess;

namespace HCM.BajaWare.BusinessLogic
{
    public class BitacoraInterfaceLogic
    {
        #region Constructor

        private BitacoraInterfaceDataAccess InterfacesDA;

        public BitacoraInterfaceLogic()
        {
            InterfacesDA = new BitacoraInterfaceDataAccess();

        }

        #endregion

        #region Obtiene Datos
        /// <summary>
        /// Obtiene la lista de personas
        /// </summary>
        /// <param name="iPersona"></param>
        /// <returns></returns>
        public List<BitacoraInterfaces> ListarBitacoraInterface()
        {
            List<BitacoraInterfaces> results = null;
            try
            {

                results = InterfacesDA.ListadoBitacoraInterface();

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        public List<BitacoraInterfaces> ListarBitacoraInterfaceID(int BitacoraID)
        {
            List<BitacoraInterfaces> results = null;
            try
            {

                results = InterfacesDA.ListadoBitacoraInterfaceID(BitacoraID);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        public List<BitacoraInterfaces> ListarBitacoraInterfaceLayout(string NegocioID, int InterfaceID, DateTime FechaCorte)
        {
            List<BitacoraInterfaces> results = null;
            try
            {

                results = InterfacesDA.ListadoBitacoraInterfaceLayout(NegocioID, InterfaceID, FechaCorte);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }


        public List<BitacoraInterfaces> ListadoUltimoBitacoraLayout(string strInterfaceIds, string strFechaCorte)
        {
            List<BitacoraInterfaces> results = null;
            try
            {
                results = InterfacesDA.ListadoUltimoBitacoraLayout(strInterfaceIds, strFechaCorte);
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }


        #endregion
    }
}
