﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.BusinessEntities;
using HCM.DataAccess;

namespace HCM.BajaWare.BusinessLogic
{
    public class CreditoEmpresarialLogic
    {
         #region Constructor

        private CreditoEmpresarialDataAccess CreditoEmpresarialDA;

        public CreditoEmpresarialLogic()
        {
            CreditoEmpresarialDA = new CreditoEmpresarialDataAccess();

        }

        #endregion

        #region Obtiene Datos
        /// <summary>
        /// Obtiene la lista de personas
        /// </summary>
        /// <param name="iPersona"></param>
        /// <returns></returns>
        public List<CreditoEmpresarial> ListarBitacoraInterface(Int32 OpereacionID)
        {
            List<CreditoEmpresarial> results = null;
            try
            {

                results = CreditoEmpresarialDA.ListadoBitacoraInterface(OpereacionID);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        public ServiceResult ActualizaCreditoEmpresarial(CreditoEmpresarial creditoEmpresarial)
        {
           ServiceResult results = new ServiceResult();
            try
            {

                results = CreditoEmpresarialDA.ActualizaCreditoEmpresarial(creditoEmpresarial);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
       

        #endregion 
    }
}
