﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.DataAccess;

namespace HCM.BajaWare.BusinessLogic
{

    public class GarantiasLogic
    {
        #region Constructor
        private GarantiasDataAcces GarantiasDA;

          public GarantiasLogic()
        {
            GarantiasDA = new GarantiasDataAcces();

        }
        #endregion
          #region Obtiene Datos
          /// <summary>
          /// Obtiene la lista de personas
          /// </summary>
          /// <param name="iPersona"></param>
          /// <returns></returns>
          public List<Garantia> ListadoGarantias(int? iOperacionId, int individual)
          {
              List<Garantia> results = null;
              try
              {

                  results = GarantiasDA.ListadoGarantias(iOperacionId, individual);

              }
              catch (Exception ex)
              {
                  throw ex;
              }
              return results;
          }
            
          #endregion 

          #region Obtiene Datos
          /// <summary>
          /// Obtiene la lista de garantias
          /// </summary>
          /// <param name="iPersona"></param>
          /// <returns></returns>
          public int InsertarEditar(Garantia garantia)
          {
              int resultado = 0;
              try
              {

                 resultado= GarantiasDA.InsertarEditar(garantia);

              }
              catch (Exception ex)
              {
                  throw ex;
              }
              return resultado;
          }

          #endregion 
    }
}
