﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Transactions;
using HCM.BusinessEntities;
using HCM.DataAccess;

namespace HCM.BajaWare.BusinessLogic
{
    public class InterfaceLogicPersonas
    {
        #region Constructor

        private ClientesDataAccess InterfacesDA;

        public InterfaceLogicPersonas()
        {
            InterfacesDA = new ClientesDataAccess();

        }

        #endregion

        #region Obtiene Datos
        /// <summary>
        /// Obtiene la lista de personas
        /// </summary>
        /// <param name="iPersona"></param>
        /// <returns></returns>
        public List<clsDatosPersona> ListaPersonas(interfacePersona iPersona)
        {
            List<clsDatosPersona> results = null;
            try
            {

                results = InterfacesDA.ListadoInterfacesPersonas(iPersona);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        /// <summary>
        /// Metodo que consume el metodo "ObtieneDatosPersona" Data Access  para obtener los datos de la persona
        /// </summary>
        /// <param name="iPersonaID"></param>
        /// <returns></returns>
        public clsDatosPersona ObtieneDatosPersona(int iPersonaID, string strNegocio)
        {
            clsDatosPersona results = null;
            try
            {

                results = InterfacesDA.ObtieneDatosPersona(iPersonaID,strNegocio);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }


        public ServiceResult InsertaDatosPersonas(clsDatosPersona clsDatPersonas, short shAreaCaptura)
        {
            ServiceResult results = null;
            try
            {

                results = InterfacesDA.InsertaDatosPersonas(clsDatPersonas, shAreaCaptura);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;

        }


        public List<CorreoPersona> ObtieneCorreos(int intPersonaID)
        {

            List<CorreoPersona> results = null;
            try
            {
                results = InterfacesDA.ObtieneCorreos(intPersonaID);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;

        }




        public ServiceResult InsertaCorreos(List<CorreoPersona> lst, int intPersonaID)
        {

            ServiceResult results = null;
            try
            {
                results = InterfacesDA.InsertaCorreos(lst, intPersonaID);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;

        }


        public ServiceResult EliminarCorreos(int intCorreoID)
        {
            ServiceResult results = null;
            try
            {
                results = InterfacesDA.EliminarCorreos(intCorreoID);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;

        }



        #endregion

        public clsDatosPersona ExistePersona(string strRFC, string strNombre)
        {
            clsDatosPersona results = null;
            try
            {
                results = InterfacesDA.ExistePersona(strRFC, strNombre);
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;

        }

        public List<Participe> ListadoParticipes(Participe participe)
        {
            List<Participe> results = null;
            try
            {

                results = InterfacesDA.ListadoParticipes(participe);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        public int InsertaPersonaParticipe(int iOperacionId, int iPersonaId, string sPrimerNombre, string sSegundoNombre, string sApellidoPaterno, string sApellidoMaterno, int iCveRegimenFiscal, string RFC, int iParticipeTipoId, int UAlta)
        {
            int results;
            try
            {

                results = InterfacesDA.InsertaPersonaParticipe(iOperacionId, iPersonaId, sPrimerNombre, sSegundoNombre, sApellidoPaterno, sApellidoMaterno, iCveRegimenFiscal, RFC, iParticipeTipoId, UAlta);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;

        }

    }
}
