﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Transactions;
using HCM.BusinessEntities;
using HCM.DataAccess;
using HCM.DataAccess.Context;

namespace HCM.BajaWare.BusinessLogic
{
    public class InterfacesLogic
    {
        #region Constructor

        private InterfacesDataAccess InterfacesDA;


        public InterfacesLogic()
        {
            InterfacesDA = new InterfacesDataAccess();

        }

        #endregion

        #region Consulta

        public List<Interfaces> Lista()
        {
            List<Interfaces> results = null;
            try
            {

                results = InterfacesDA.ListadoInterfaces();

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        #endregion

        public int Insertar(Interfaces oInterfaces)
        {
            int InterfacesID;
            try
            {
                using (TransactionScope tx = new TransactionScope(TransactionScopeOption.Required))
                {
                    InterfacesID = InterfacesDA.Insertar(oInterfaces);
                    tx.Complete();
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return InterfacesID;
        }

        public void Actualizar(Interfaces oInterfaces)
        {

            try
            {
                using (TransactionScope tx = new TransactionScope(TransactionScopeOption.Required))
                {
                    InterfacesDA.Actualizar(oInterfaces);
                    tx.Complete();
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }

        }

        public void Baja(int InterfacesID)
        {
            try
            {
                using (TransactionScope tx = new TransactionScope(TransactionScopeOption.Required))
                {
                    InterfacesDA.Baja(InterfacesID);
                    tx.Complete();
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        public List<Interfaces> Editar(int InterfacesID)
        {
            List<Interfaces> results = null;
            try
            {

                results = InterfacesDA.EditarInterfaces(InterfacesID);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }


        public List<CreditosResult> ObtieneCreditos(CreditosBusqueda busqueda)
        {

            List<CreditosResult> results = null;
            try
            {
                results = InterfacesDA.ObtieneCreditos(busqueda);
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        public List<Interfaces> ListadoInterfacesPorNegocio(char chNegocio, short shDepartamentoID)
        {
            List<Interfaces> results = null;
            try
            {

                results = InterfacesDA.ListadoInterfacesPorNegocio(chNegocio, shDepartamentoID);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        public ServiceResult EjecutaInterfaces(EjecutaInterface clsInter)
        {
            ServiceResult results = null;
            try
            {
                results = InterfacesDA.EjecutaInterfaces(clsInter);

            }
            catch (Exception ex)
            {

                throw ex;
            }
            return results;

        }


        public List<DateTime> ListaFechasInterfaces(string strFechIni, string strFechFin)
        {

            List<DateTime> results = null;
            try
            {
                results = InterfacesDA.ListaFechasInterfaces(strFechIni, strFechFin);

            }
            catch (Exception ex)
            {

                throw ex;
            }
            return results;

        }

        public bool almacenarArchivo(string fuente, string destino, string archivo)
        {
            bool result;
            try
            {
                result = InterfacesDA.almacenarArchivo(fuente, destino, archivo);
            }
            catch (Exception ex)
            {

                throw ex;
            }
            return result;
        }

        public string nombreArchivo(string _nombre)
        {
            string result;
            try
            {
                result = InterfacesDA.nombreArchivo(_nombre);
            }
            catch (Exception ex)
            {

                throw ex;
            }
            return result;
        }

    }
}
