﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.DataAccess;

namespace HCM.BajaWare.BusinessLogic
{
    public class InterfacesLogicDomicilio
    {
        #region Constructor

        private ClientesDataAccess InterfacesDA;


        public InterfacesLogicDomicilio()
        {
            InterfacesDA = new ClientesDataAccess();

        }

        #endregion


        #region Obtiene Domicilio

        public List<clsDomicilio> ObtieneDomicilio(int iPersonaID, string strNegocio)
        {
            List<clsDomicilio> results = null;
            try
            {
                results = InterfacesDA.ObtieneDomicilio(iPersonaID, strNegocio);
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        public bool ExisteDomicilio(int iPersonaID, string strNegocio)
        {
            bool results = false;
            try
            {
                results = InterfacesDA.ExisteDomicilio(iPersonaID, strNegocio);
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        #endregion


        #region Actualiza e inserta Datos
        public ServiceResult InsertaDatosDomicilio(clsDomicilio clsDom)
        {
            ServiceResult result = new ServiceResult();
            try
            {
                result = InterfacesDA.InsertaDomicilio(clsDom);

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;

        }
        #endregion

    }
}
