﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Diagnostics;

namespace HCM.BajaWare.Services
{
    public class EventLogManager
    {
        private static string AppName = "HCM";

        public static void LogInfoEntry(string InfoMessage)
        {
            EventLog elog = new EventLog();

            if (!EventLog.SourceExists(AppName))
            {
                EventLog.CreateEventSource(AppName, AppName);
            }

            elog.Source = AppName;
            elog.EnableRaisingEvents = true;
            elog.WriteEntry(InfoMessage, EventLogEntryType.Information);
        }

        public static void LogErrorEntry(string ErrorMessage)
        {
            EventLog elog = new EventLog();

            if (!EventLog.SourceExists(AppName))
            {
                EventLog.CreateEventSource(AppName, AppName);
            }

            elog.Source = AppName;
            elog.EnableRaisingEvents = true;
            elog.WriteEntry(ErrorMessage, EventLogEntryType.Error);
        }

    }
}

