﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.ServiceModel;
using HCM.BusinessEntities;

namespace HCM.BajaWare.Services
{
    [ServiceContract]
    interface IinterfacesService
    {
        [OperationContract]
        List<Interfaces> ListarInterfaces();

        [OperationContract]
        List<BitacoraInterfaces> ListarBitacoraInterface();

        [OperationContract]
        List<BitacoraInterfaces> ListarBitacoraInterfaceID(int BitacoraID);

        [OperationContract]
        List<BitacoraInterfaces> ListarBitacoraInterfaceLayout(string NegocioID, int InterfaceID, DateTime FechaCorte);

        [OperationContract]
        ServiceResult InsertarInterfaces(Interfaces oInterfaces);

        [OperationContract]
        ServiceResult ActualizarInterfaces(Interfaces oInterfaces);

        [OperationContract]
        ServiceResult BajaInterfaces(int InterfacesID);

        [OperationContract]
        List<Interfaces> EditarInterfaces(int InterfacesID);

        [OperationContract]
        List<CreditosResult> ObtieneCreditos(CreditosBusqueda busqueda);

        [OperationContract]
        List<Interfaces> ListadoInterfacesPorNegocio(char chNegocio, short shDepartamentoID);

        [OperationContract]
        List<BitacoraInterfaces> ListadoUltimoBitacoraLayout(string strInterfaceIds, string strFechaCorte);

        [OperationContract]
        ServiceResult EjecutaInterfaces(EjecutaInterface clsInter);

        [OperationContract]
        List<DateTime> ListaFechasInterfaces(string strFechIni, string strFechFin);

        [OperationContract]
        ServiceResult almacenarArchivo(string fuente, string destino, string archivo);

        [OperationContract]
        string nombreArchivo(string _nombre);
    }
}
