﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.ServiceModel;
using HCM.BusinessEntities;
using HCM.BajaWare.BusinessLogic;

namespace HCM.BajaWare.Services
{
    public partial class CreditoEmpresarialService : ICreditoEmpresarialService
    {
        public List<CreditoEmpresarial> ListarCreditoEmpresarial(Int32 OperacionID)
        {
            List<CreditoEmpresarial> result = null;
            try
            {
                result = (new CreditoEmpresarialLogic()).ListarBitacoraInterface(OperacionID);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en CreditoEmpresarialService.ListarCreditoEmpresarial: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CreditoEmpresarialService.ListarCreditoEmpresarial: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }

         public ServiceResult ActualizaCreditoEmpresarial(CreditoEmpresarial creditoEmpresarial)
        {
            ServiceResult result = new ServiceResult();
            try
            {
                result = (new CreditoEmpresarialLogic()).ActualizaCreditoEmpresarial(creditoEmpresarial);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en CreditoEmpresarialService.ActualizaCreditoEmpresarial: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CreditoEmpresarialService.ListarCreditoEmpresarial: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }
    }
    
}
