﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.BajaWare.BusinessLogic;

namespace HCM.BajaWare.Services
{
    public partial  class InterfaceServicesAavales:IinterfacesServiceAval
    {
        public List<Aval> ObtieneAvales(int Consec)
        {
            List<Aval> result = null;
            try
            {
                result = (new AvalesLogic()).ListadoAccionistas(Consec);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfaceServicesAavales. ObtieneAvales: " + ex.Message);
#else
                    EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
                    //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }
        public ServiceResult InsertaActualizaAval(Aval aval)
        {
            ServiceResult result = new ServiceResult();
            try
            {
                result = (new AvalesLogic()).InsertarEditar(aval);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfaceServicesAavales. InsertaActualizaAval: " + ex.Message);
#else
                    EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
                    //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
        }
    }
}
