﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.BajaWare.BusinessLogic;

namespace HCM.BajaWare.Services
{
    public partial class InterfaceServicesAccionistas:IinterfacesServiceAccionista
    {
        public List<Accionista> ObtieneAccionistas(Accionista accionista)
        {
            List<Accionista> result = null;
            try
            {
                result = (new AccionistasLogic()).ListadoAccionistas(accionista);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfaceServicesAccionistas. ObtieneAccionistas: " + ex.Message);
#else
                    EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
                    //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }
        public ServiceResult InsertaActualizaAccionista(Accionista accionista)
        {
            ServiceResult result = new ServiceResult();
            try
            {
                result = (new AccionistasLogic()).InsertarEditar(accionista);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfaceServicesAccionistas. InsertaActualizaAccionista: " + ex.Message);
#else
                    EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
                    //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
        }
    }
}
