﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.ServiceModel;
using HCM.BusinessEntities;
using HCM.BajaWare.BusinessLogic;

namespace HCM.BajaWare.Services
{
    public partial class InterfacesService : IinterfacesService
    {
        public List<Interfaces> ListarInterfaces()
        {
            List<Interfaces> result = null;
            try
            {
                result = (new InterfacesLogic()).Lista();
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en CatalogosService.ListarInterfaces: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }

        public List<BitacoraInterfaces> ListarBitacoraInterface()
        {
            List<BitacoraInterfaces> result = null;
            try
            {
                result = (new BitacoraInterfaceLogic()).ListarBitacoraInterface();
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesService.ListarBitacoraInterface: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en InterfacesService.ListarBitacoraInterface: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }

        public List<BitacoraInterfaces> ListarBitacoraInterfaceID(int BitacoraID)
        {
            List<BitacoraInterfaces> result = null;
            try
            {
                result = (new BitacoraInterfaceLogic()).ListarBitacoraInterfaceID(BitacoraID);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesService.ListarBitacoraInterfaceID: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en InterfacesService.ListarBitacoraInterfaceID: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }

        public List<BitacoraInterfaces> ListarBitacoraInterfaceLayout(string NegocioID, int InterfaceID, DateTime FechaCorte)
        {
            List<BitacoraInterfaces> result = null;
            try
            {
                result = (new BitacoraInterfaceLogic()).ListarBitacoraInterfaceLayout(NegocioID, InterfaceID, FechaCorte);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesService.ListarBitacoraInterfaceLayout: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en InterfacesService.ListarBitacoraInterfaceLayout: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }

        public ServiceResult InsertarInterfaces(Interfaces oInterfaces)
        {
            ServiceResult resultado = new ServiceResult();

            try
            {
                resultado.ResultValue = (new InterfacesLogic()).Insertar(oInterfaces);
                resultado.ServiceOk = true;
            }
            catch (Exception ex)
            {
                resultado.ErrorMessage = "Error en InterfacesService.InsertarInterfaces: " + ex.Message;
#if (DEBUG)
                Console.WriteLine(resultado.ErrorMessage);
#else
                //EventLogManager.LogErrorEntry(result.ErrorMessage);
#endif
            }
            return resultado;
        }

        public ServiceResult ActualizarInterfaces(Interfaces oInterfaces)
        {
            ServiceResult resultado = new ServiceResult();

            try
            {
                (new InterfacesLogic()).Actualizar(oInterfaces);
                resultado.ServiceOk = true;
            }
            catch (Exception ex)
            {
                resultado.ErrorMessage = "Error en InterfacesService.ActualizarInterfaces: " + ex.Message;
#if (DEBUG)
                Console.WriteLine(resultado.ErrorMessage);
#else
                //EventLogManager.LogErrorEntry(result.ErrorMessage);
#endif
            }
            return resultado;
        }

        public ServiceResult BajaInterfaces(int InterfacesID)
        {
            ServiceResult resultado = new ServiceResult();

            try
            {
                (new InterfacesLogic()).Baja(InterfacesID);
                resultado.ServiceOk = true;
            }
            catch (Exception ex)
            {
                resultado.ErrorMessage = "Error en InterfacesService.BajaInterfaces: " + ex.Message;
#if (DEBUG)
                Console.WriteLine(resultado.ErrorMessage);
#else
                //EventLogManager.LogErrorEntry(result.ErrorMessage);
#endif
            }
            return resultado;
        }

        public List<Interfaces> EditarInterfaces(int InterfacesID)
        {
            List<Interfaces> result = null;
            try
            {
                result = (new InterfacesLogic()).Editar(InterfacesID);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesService.EditarInterfaces: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
        }


        public List<CreditosResult> ObtieneCreditos(CreditosBusqueda busqueda)
        {
            List<CreditosResult> result = null;
            try
            {
                result = (new InterfacesLogic()).ObtieneCreditos(busqueda);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesService. ObtieneCreditos: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
        }

        public List<Interfaces> ListadoInterfacesPorNegocio(char chNegocio, short shDepartamentoID)
        {
            List<Interfaces> result = null;
            try
            {
                result = (new InterfacesLogic()).ListadoInterfacesPorNegocio(chNegocio, shDepartamentoID);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesService. ListadoInterfacesPorNegocio: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
        }

        public List<BitacoraInterfaces> ListadoUltimoBitacoraLayout(string strInterfaceIds, string strFechaCorte)
        {


            List<BitacoraInterfaces> result = null;
            try
            {
                result = (new BitacoraInterfaceLogic()).ListadoUltimoBitacoraLayout(strInterfaceIds, strFechaCorte);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesService. ListadoUltimoBitacoraLayout: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
        }


        public ServiceResult EjecutaInterfaces(EjecutaInterface clsInter)
        {
            ServiceResult result = null;
            try
            {
                result = (new InterfacesLogic()).EjecutaInterfaces(clsInter);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesService. EjecutaInterfaces: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }


        public List<DateTime> ListaFechasInterfaces(string strFechIni, string strFechFin)
        {
            List<DateTime> result = null;
            try
            {
                result = (new InterfacesLogic()).ListaFechasInterfaces(strFechIni, strFechFin);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesService. ListaFechasInterfaces: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
        }

        public ServiceResult almacenarArchivo(string fuente, string destino, string archivo)
        {
            ServiceResult result = new ServiceResult();
            try
            {
                result.ServiceOk = (new InterfacesLogic()).almacenarArchivo(fuente, destino, archivo);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en Interfaces. almacenarArchivo: " + ex.Message);
                //EventLogManager.LogErrorEntry(result.ErrorMessage);
#endif
                result.ResultValue = ex.Message;
            }
            return result;
        }

        public string nombreArchivo(string _nombre)
        {
            string result = "";
            try
            {
                result = (new InterfacesLogic()).nombreArchivo(_nombre);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en Interfaces. nombreArchivo: " + ex.Message);
                //EventLogManager.LogErrorEntry(result.ErrorMessage);
#endif
            }
            return result;
        }

    }


}
