﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using HCM.BusinessEntities;
using HCM.BajaWare.BusinessLogic;

namespace HCM.BajaWare.Services
{
    public partial class InterfacesServiceCreditHipot : IinterfacesServiceCreditHipot
    {
        public List<CreditoHipotecario> ListarCreditHipotecario(CreditoHipotecario creditoHipotecario)
        {
            List<CreditoHipotecario> result = null;
            try
            {
                result = (new CreditoHipotecarioLogic()).ListadoCreditoHipotecario(creditoHipotecario);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesServiceCreditHipot.ListarCreditHipotecario: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CreditoEmpresarialService.ListarCreditoEmpresarial: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }

        public ServiceResult ActualizaCreditoHipotecario(CreditoHipotecario creditoHipotecario)
        {
            ServiceResult result = new ServiceResult();
            try
            {
                result = (new CreditoHipotecarioLogic()).ActualizaCreditoHipotecario(creditoHipotecario);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesServiceCreditHipot.ActualizaCreditoHipotecario: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CreditoEmpresarialService.ListarCreditoEmpresarial: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }

        public clsDomicilio ObtieneEstadoMunicipio(string sCodigoPostal)
        {
            clsDomicilio result = new clsDomicilio();
            try
            {
                result = (new CreditoHipotecarioLogic()).ObtieneEstadoMunicipio(sCodigoPostal);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesServiceCreditHipot.ObtieneEstadoMunicipio: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CreditoEmpresarialService.ObtieneEstadoMunicipio: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
        }
    }
}
