﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.BajaWare.BusinessLogic;


namespace HCM.BajaWare.Services
{
    public partial class InterfacesServicePersonas : IinterfacesServiceDomicilio
    {


        public List<clsDomicilio> ObtieneDomicilio(int iPersonaID, string strNegocio)
        {
            List<clsDomicilio> result = null;
            try
            {
                result = (new InterfacesLogicDomicilio()).ObtieneDomicilio(iPersonaID, strNegocio);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en CatalogosService. ListarInterfaces: " + ex.Message);
#else
                    EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
                    //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }


        public ServiceResult InsertaDomicilio(clsDomicilio clsDom)
        {
            ServiceResult result = new ServiceResult();
            try
            {
                result = (new InterfacesLogicDomicilio()).InsertaDatosDomicilio(clsDom);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en Domicilio Service. InsertaDatosDomicilio: " + ex.Message);
#else
                    EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
                    //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }



        public bool ExisteDomicilio(int intPersonaID, string strNegocio)
        {
            bool result = false;
            try
            {
                result = (new InterfacesLogicDomicilio()).ExisteDomicilio(intPersonaID, strNegocio);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en Domicilio Service. ExisteDomicilioFiscal: " + ex.Message);
#else
                    EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
                    //TODO: Codificar envío de notificación de error al EventLog
#endif
            }

            return result;
        }


    }
}
