﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.BajaWare.BusinessLogic;

namespace HCM.BajaWare.Services
{
    public partial class InterfacesServiceGarantias : IinterfacesServiceGarantia
    {
        public List<Garantia> ObtieneGarantias(int? iOperacionId, int individual)
        {
            List<Garantia> result = null;
            try
            {
                result = (new GarantiasLogic()).ListadoGarantias(iOperacionId,individual);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en InterfacesServiceGarantias. ListadoGarantias: " + ex.Message);
#else
                    EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
                    //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }

      
        public ServiceResult InsertaActualizaGarantia(Garantia garantia)
        {
            ServiceResult resultado = new ServiceResult();

            try
            {
                resultado.ResultValue=(new GarantiasLogic()).InsertarEditar(garantia);
                resultado.ServiceOk = true;
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en Garantia Service. InsertarEditarGarantia: " + ex.Message);
#else
                    EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
                    //TODO: Codificar envío de notificación de error al EventLog
#endif
            }

            return resultado;
        }
    }
}
