﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.BajaWare.BusinessLogic;


namespace HCM.BajaWare.Services
{
    public partial class InterfacesServicePersonas : IinterfacesServicePersonas
    {
        public List<clsDatosPersona> ListaBajawarePersonas(interfacePersona iPersona)
        {
            List<clsDatosPersona> result = null;
            try
            {
                result = (new InterfaceLogicPersonas()).ListaPersonas(iPersona);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en ServicePersonas.ListarInterfaces: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }

        public clsDatosPersona ObtieneDatosPersona(int iPersonaID, string strNegocio)
        {

            clsDatosPersona result = null;


            try
            {
                result = (new InterfaceLogicPersonas()).ObtieneDatosPersona(iPersonaID,strNegocio);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en ServicePersonas.ListarInterfaces: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;


        }



        public List<CorreoPersona> ObtieneCorreos(int intPersonaID)
        {

            List<CorreoPersona> result = null;


            try
            {
                result = (new InterfaceLogicPersonas()).ObtieneCorreos(intPersonaID);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en ServicePersonas. ObtieneCorreos: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;


        }

        public ServiceResult InsertaCorreos(List<CorreoPersona> lstCorreos, int intPersonaID)
        {
            ServiceResult result = null;


            try
            {
                result = (new InterfaceLogicPersonas()).InsertaCorreos(lstCorreos, intPersonaID);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en ServicePersonas. InsertaCorreos: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;


        }

        public ServiceResult EliminarCorreos(int intCorreoID)
        {
            ServiceResult result = null;


            try
            {
                result = (new InterfaceLogicPersonas()).EliminarCorreos(intCorreoID);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en ServicePersonas. InsertaCorreos: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;


        }


        public ServiceResult InsertaDatosPersonas(clsDatosPersona clsDatPersonas, short shAreaCaptura)
        {
            ServiceResult result = null;


            try
            {
                result = (new InterfaceLogicPersonas()).InsertaDatosPersonas(clsDatPersonas, shAreaCaptura);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en ServicePersonas. InsertaDatosPersonas: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
        }




        public clsDatosPersona ExistePersona(string strRFC, string strNombre)
        {
            clsDatosPersona result = null;


            try
            {
                result = (new InterfaceLogicPersonas()).ExistePersona(strRFC, strNombre);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en ServicePersonas. InsertaDatosPersonas: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
        }

        public List<Participe> ListaParticipe(Participe participe)
        {
            List<Participe> result = null;
            try
            {
                result = (new InterfaceLogicPersonas()).ListadoParticipes(participe);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en ServicePersonas.ListarInterfaces: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en CatalogosService.ListarInterfaces: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;

        }

        public int InsertaPersonaParticipe(int iOperacionId, int iPersonaId, string sPrimerNombre, string sSegundoNombre, string sApellidoPaterno, string sApellidoMaterno, int iCveRegimenFiscal, string RFC, int iParticipeTipoId, int UAlta)
        {
            int result = 0;
            try
            {
                result = (new InterfaceLogicPersonas()).InsertaPersonaParticipe(iOperacionId, iPersonaId, sPrimerNombre, sSegundoNombre, sApellidoPaterno, sApellidoMaterno, iCveRegimenFiscal, RFC, iParticipeTipoId, UAlta);
            }
            catch (Exception ex)
            {
#if (DEBUG)
                Console.WriteLine("Error en ServicePersonas.InsertaPersonaParticipe: " + ex.Message);
#else
               EventLogManager.LogErrorEntry("Error en ServicePersonas.InsertaPersonaParticipe: " + ex.Message);
               //TODO: Codificar envío de notificación de error al EventLog
#endif
            }
            return result;
            return result;
        }

    }







}
