﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class AccionistasDataAcces
    {
        public int InsertarEditar(Accionista accionista)
        {
            int resultado = 0;
            try
            {
                using (lnqAccionistaDataContext dc = new lnqAccionistaDataContext(Helper.ConnectionString()))
                {
                     resultado= dc.sp_iPersonasAccionista(accionista.iPersonaId, accionista.iCveRegimenFiscal, accionista.sApellidoPaterno, accionista.sApellidoMaterno, accionista.sPrimerNombre, accionista.sSegundoNombre, accionista.pParticipacion, accionista.iOperacionId, accionista.Consec, accionista.UAlta).First().Consec;
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return resultado;
        }
        public List<Accionista> ListadoAccionistas(Accionista accionista)
        {

            List<Accionista> results = new List<Accionista>();

            try
            {
                using (lnqAccionistaDataContext dc = new lnqAccionistaDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.sp_getAccionista(accionista.iOperacionId,accionista.Consec)
                                select new Accionista()
                                {
                                    iPersonaId=item.iPersonaId
                                   ,iCveRegimenFiscal=item.iCveRegimenFiscal
                                   ,sApellidoPaterno=item.sApellidoPaterno
                                   ,sApellidoMaterno=item.sApellidoMaterno
                                   ,sPrimerNombre=item.sPrimerNombre
                                   ,sSegundoNombre=item.sSegundoNombre
                                   ,pParticipacion=Convert.ToDecimal(item.pParticipacion)
                                   ,Consec=item.Consec
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

    }
}
