﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.DataAccess.Context;

namespace HCM.DataAccess
{
    public class AreaDataAccess
    {

        #region Consulta

        public List<Area> ListadoArea()
        {

            List<Area> results = new List<Area>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarAreas()
                                select new Area()
                                {
                                    shAreaID = item.sintAreaID,
                                    vchDescripcion = item.vchNombre
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
