﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.DataAccess.Context;
using HCM.BusinessEntities;


namespace HCM.DataAccess
{
    public class AvalDataAcces
    {
        public int InsertarEditar(Aval aval)
        {
            int resultado = 0;
            try
            {
                using (lnqAvalDataContext dc = new lnqAvalDataContext(Helper.ConnectionString()))
                {
                    resultado = dc.sp_iAval(aval.iOperacionId, aval.iParticipeId, aval.Consec, aval.sPrimerNombre, aval.sSegundoNombre, aval.sApellidoPaterno, aval.sApellidoMaterno,aval.iCveRegimenFiscal, aval.RFC, (byte?)aval.tintTipoAvalID, (short?)aval.sintActividadINEGIID, aval.tintRiesgoIndustriaID == 0 ? null : (byte?)aval.tintRiesgoIndustriaID, aval.tintRiesgoFinancieroID == 0 ? null : (byte?)aval.tintRiesgoFinancieroID, aval.tintRiesgoExperPagoID == 0 ? null : (byte?)aval.tintRiesgoExperPagoID, aval.uAlta);
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return resultado;
        }

        public List<Aval> ListadoAval(int Consec)
        {

            List<Aval> results = new List<Aval>();

            try
            {
                using (lnqAvalDataContext dc = new lnqAvalDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.sp_getAval(Consec)
                                select new Aval()
                                {
                                    
                                    iParticipeId=item.iParticipeId,
                                    sPrimerNombre = item.sPrimerNombre,
                                    sSegundoNombre=item.sSegundoNombre,
                                    sApellidoPaterno=item.sApellidoPaterno,
                                    sApellidoMaterno=item.sApellidoMaterno,
                                    RFC=item.RFC==null?string.Empty:item.RFC,
                                    iCveRegimenFiscal=item.iCveRegimenFiscal,
                                    tintTipoAvalID = Convert.ToInt16(item.tintTipoAvalID == null ? 0 : item.tintTipoAvalID),
                                   sintActividadINEGIID=Convert.ToInt16(item.sintActividadINEGIID==null?0:item.sintActividadINEGIID),
                                   tintRiesgoIndustriaID=Convert.ToInt16(item.tintRiesgoIndustriaID==null?0:item.tintRiesgoIndustriaID),
                                   tintRiesgoFinancieroID=Convert.ToInt16(item.tintRiesgoFinancieroID==null?0:item.tintRiesgoFinancieroID),
                                   tintRiesgoExperPagoID=Convert.ToInt16(item.tintRiesgoExperPagoID==null?0:item.tintRiesgoExperPagoID),
                                   Consec=item.Consec                         

                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }
    }
}
