﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
   public class BitacoraInterfaceDataAccess
    {
        #region Consulta

        public List<BitacoraInterfaces> ListadoBitacoraInterface()
        {

            List<BitacoraInterfaces> results = new List<BitacoraInterfaces>();

            try
            {
                using (InterfacesDataContext dc = new InterfacesDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarBitacoraInterface()
                                select new BitacoraInterfaces()
                                {
                                    intBitDetID = item.intBitDetID,
                                    Layout = item.Layout,
                                    Interface = item.Interface,
                                    Usuario = item.Usuario,
                                    Fecha = (DateTime)item.Fecha
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        public List<BitacoraInterfaces> ListadoBitacoraInterfaceID(int BitacoraID)
        {

            List<BitacoraInterfaces> results = new List<BitacoraInterfaces>();

            try
            {
                using (InterfacesDataContext dc = new InterfacesDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarBitacoraInterfaceID(BitacoraID)
                                select new BitacoraInterfaces()
                                {
                                    intBitDetID = item.intBitDetID,
                                    Layout = item.Layout,
                                    Interface = item.Interface,
                                    Usuario = item.Usuario,
                                    Fecha = (DateTime)item.Fecha
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        public List<BitacoraInterfaces> ListadoBitacoraInterfaceLayout(string NegocioID, int InterfaceID, DateTime FechaCorte)
        {

            List<BitacoraInterfaces> results = new List<BitacoraInterfaces>();

            try
            {
                using (InterfacesDataContext dc = new InterfacesDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarBitacoraInterfaceLayout(NegocioID, InterfaceID , FechaCorte)
                                select new BitacoraInterfaces()
                                {
                                    intBitDetID = item.intBitDetID,
                                    Layout = item.Layout,
                                    Interface = item.Interface,
                                    Usuario = item.Usuario,
                                    Fecha = (DateTime)item.Fecha
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }


        public List<BitacoraInterfaces> ListadoUltimoBitacoraLayout(string strInterfaceIds,string strFechaCorte)
        {

            List<BitacoraInterfaces> results = new List<BitacoraInterfaces>();

            try
            {
                using (InterfacesDataContext dc = new InterfacesDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarUltimasInterfaceLayout(strInterfaceIds, strFechaCorte)
                                select new BitacoraInterfaces()
                                {
                                    intBitDetID = item.intBitDetID,
                                    Layout = item.Layout,
                                    Interface = item.Interface,
                                    Usuario = item.Usuario,
                                    Fecha = (DateTime)item.Fecha,
                                    Negocio = item.vcNegocioTipo.ToString()
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }
       
        #endregion
    }
}
