﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.DataAccess.Context;

namespace HCM.DataAccess
{
    public class CatalogosPersonaDataAccess
    {
        #region Obtiene Datos Catalogos


        private List<Interfaces> AgregaItemSeleccion(List<Interfaces> lst)
        {

            Interfaces i = new Interfaces();
            i.intInterfaceid = 0;
            i.vchInterface = "[Seleccionar...]";
            lst.Insert(0, i);

            return lst;
        }

        private List<Interfaces> AgregaItemSeleccionMenosUno(List<Interfaces> lst)
        {

            Interfaces i = new Interfaces();
            i.intInterfaceid = -1;
            i.vchInterface = "[Seleccionar...]";
            lst.Insert(0, i);

            return lst;
        }


        public List<Interfaces> ListadoRelacionAcreditado()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_RelacionAcreditado
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintRelAcredID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);

                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }


        public List<Interfaces> ListadoSectorLaboral()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_SectorLaboral
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintSectorLabID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }


        public List<Interfaces> ListadoTipoDeudorRelacionado()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_TipoDeudorRelacionado
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintTipoDeudorRelID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }



        public List<Interfaces> ListadoComprobanteIngresos()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_ComprobanteIngreso
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintCompIngreID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        public List<Interfaces> ListadoActividades()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_Actividades
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintActividadID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }

        public List<Interfaces> ListadoTamDeudor()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_TamanoDeudor
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintTamDeudorID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }

        public List<Interfaces> ListadoPersonalidadJuridica()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_sistema_catalogos
                                where item.iAgrupaCatId == 19 //    
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.iCatalogoId,
                                    vchInterface = item.sDescCatalogo
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }

        public List<Interfaces> ListadoRegimenFiscal()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_sistema_catalogos
                                where item.iAgrupaCatId == 19 //    
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.iCatalogoId,
                                    vchInterface = item.sDescCatalogo
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }

        public List<Interfaces> ListadoPaises()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_sistema_catalogos
                                where item.iAgrupaCatId == 60 //MEXICO
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.iCatalogoId,
                                    vchInterface = item.sDescCatalogo
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }


        public List<Interfaces> ListadoEstados()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_sistema_catalogos
                                where item.iAgrupaCatId == 356 //MEXICO
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.iCatalogoId,
                                    vchInterface = item.sDescCatalogo
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }

        public List<Interfaces> ListadoMunicipios(short shEstaodID)
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = (from item in dc.tbl_sistema_sepomex
                                 where item.iClaveEstado == shEstaodID
                                 select new Interfaces()
                                 {
                                     intInterfaceid = (Int16)item.iClaveMunicipio,
                                     vchInterface = item.sMunicipio
                                 }).Distinct();

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }

        public List<Interfaces> ListadoColonias(string strCP)
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = (from item in dc.tbl_sistema_sepomex
                                 where item.sCodigoPostal == strCP
                                 select new Interfaces()
                                 {
                                     intInterfaceid = (Int16)item.iClaveMunicipio,
                                     vchInterface = item.sColonia.ToUpper().Replace('Á', 'A').Replace('É', 'E').Replace('Í', 'I').Replace('Ó', 'O').Replace('Ú', 'U')
                                 }).Distinct();

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }


        public SepomexResult ObtineEdoMpoPorCP(string strCP)
        {

            SepomexResult results = new SepomexResult();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = (from item in dc.tbl_sistema_sepomex
                                 where item.sCodigoPostal == strCP
                                 select new SepomexResult()
                                 {
                                     strEstado = item.iClaveEstado.ToString(),
                                     strMunicipio = item.iClaveMunicipio.ToString()
                                 }).Distinct();

                    results = query.FirstOrDefault();
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }


        public List<Interfaces> ListadoLocalidades(short shEstado)
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = (from item in dc.tbl_CAT_Localidades
                                 where item.sintEstadoID == shEstado
                                 select new Interfaces()
                                 {
                                     intInterfaceid = (Int16)item.sintLocalidadID,
                                     vchInterface = item.vchDescripcion
                                 }).Distinct();

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }


        public List<Interfaces> ListadoTipoDomicilio()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_sistema_catalogos
                                where item.iAgrupaCatId == 22 //MEXICO
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.iCatalogoId,
                                    vchInterface = item.sDescCatalogo
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }




        public List<Interfaces> ListadoSector()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_Sector
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintSectorID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

                return results;
            }
            catch (Exception ex)
            {
                throw ex;
            }

        }

        public List<Interfaces> ListadoTipoGarantia(int negocio)//Individual
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    List<short> ids;
                    if(negocio==1)//Individual
                    {
                        ids = new List<short>(){5,6};

                    }
                    else //Empresarial
                    {
                         ids = new List<short>(){1,5,16,17};
                    }
                    var query = (from item in dc.tbl_CAT_TipoGarantia
                                 where ids.Contains(item.sintTipoGarantiaID)
                                 select new Interfaces()
                                 {
                                     intInterfaceid = (Int16)item.sintTipoGarantiaID,
                                     vchInterface = item.vchDescripcion
                                 }).Distinct();

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }
        public List<Interfaces> ListadoMoneda()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = (from item in dc.tbl_CAT_Moneda
                                 select new Interfaces()
                                 {
                                     intInterfaceid = (Int16)item.sintMonedaID,
                                     vchInterface = item.vchDescripcion
                                 }).Distinct();

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }
        public List<Interfaces> ListadoInstitucion()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = (from item in dc.tbl_CAT_Institucion
                                 select new Interfaces()
                                 {
                                     intInterfaceid = (Int16)item.sintInstitucionID,
                                     vchInterface = item.vchDescripcion
                                 }).Distinct();

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }
        public List<Interfaces> ListadoTipoAval()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_TipoAval
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintTipoAvalID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }
        public List<Interfaces> ListadoIndustria()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_ActividadINEGI
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintActividadINEGIID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }
        public List<Interfaces> ListadoGradoRiesgo()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_GradoRiesgo
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintGradoRiesgoID,
                                    vchInterface = item.vchBWGradoRiesgoID
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }

        public List<Interfaces> ListadoEjecutivosBancarios()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_EjecutivosBancarios
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintEjecutivoID,
                                    vchInterface = item.vchNombre
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }


        public List<Interfaces> ListadoSucursalesBancarias()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatSucursalesBancarias()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintSucursalBanID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;

        }

        public List<Interfaces> ListadoPeriodicidadInt()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_PeriodicidadInt
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintPeriodicidadInt,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }
        public List<Interfaces> ListadoTipoCreditoR04A()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_TipoCreditoR04A
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintTipoCreditoID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }

        public List<Interfaces> ListadoPreferencia()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_Preferencia
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintPreferenciaID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }
        public List<Interfaces> ListadoTipoLineaRevoca()
        {

            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_TipoLineaRevoca
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintTipoLinRevID,
                                    vchInterface = item.vchDescripción
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }
        public List<Interfaces> ListadoComprobanteIngresosInividual()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_sistema_catalogos
                                where item.iAgrupaCatId == 59
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.iCatalogoId,
                                    vchInterface = item.sDescCatalogo
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        public List<Interfaces> ListadoDestinoCredito()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatDestinoCredito()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintDestinoCredID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListarTasaReferencia
        public List<Interfaces> ListarTasaReferencia()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatTasaReferencia()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintTasaRefID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListaClasificacionLegal
        public List<Interfaces> ListaClasificacionLegal()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatClasificacionLegal()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintClasificaLegID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListaReestructura
        public List<Interfaces> ListaReestructura()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatReestructura()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintEstatusRestrucID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListaNumeroAgrupacion
        public List<Interfaces> ListaNumeroAgrupacion()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatNumeroAgrupacion()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.iGrupoId,
                                    vchInterface = item.Grupo_Desc
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListaOperacionFormalizada
        public List<Interfaces> ListarOperacionFormalizada()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatOperacionFormalizada()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintOperFormaID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListarInformacionRecuperacion
        public List<Interfaces> ListarInformacionRecuperacion()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatInformacionRecuperacion()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintInfoRecuperaID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListarExpedienteCompleto
        public List<Interfaces> ListarExpedienteCompleto()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatExpedienteCompleto()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintExpedienCompID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListarMetodologia
        public List<Interfaces> ListarMetodologia()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatMetodologia()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintMetodologiaID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListarTipoAlta
        public List<Interfaces> ListarTipoAlta()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatTipoAlta()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintTipoAltaID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListarDisposicionCredito
        public List<Interfaces> ListarDisposicionCredito()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatDispCredito()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintTipoDispCredID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListarInstitucion
        public List<Interfaces> ListarInstitucion()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatInstitucion()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintInstitucionID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListarTipoBaja
        public List<Interfaces> ListarTipoBaja()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatTipoBaja()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintTipoBajaID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        //ListarPeriodicidadCap
        public List<Interfaces> ListarPeriodicidadCap()
        {


            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatPeriodicidadCap()
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintPeriodicidadCap,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        public List<Interfaces> ListarEntidadCofinanciadora()
        {
            //tbl_MST_GeneralesInd
            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_EntidadCofinanciadora
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintEntidadCofinanID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        public List<Interfaces> ListarProductoHipotecario()
        {
            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_Condiciones
                                where item.iProductoId == 8
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.iCondicionId,
                                    vchInterface = item.Condicion_Desc
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        public List<Interfaces> ListarTipoSeguro()
        {
            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_TipoSeguro
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintTipoSeguroID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        public List<Interfaces> ListarTipoTasaInteres()
        {
            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_TipoTasaInteres
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.tintTipoTasaIntID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccionMenosUno(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        public List<Interfaces> ListarEntidadSeguro()
        {
            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_EntidadSeguro
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintEntAsegID,
                                    vchInterface = item.vchDescripcion
                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        public List<Interfaces> ListarClasificacionContable()
        {
            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_NombreProducto
                                where item.chTipo == '2' && item.bitEstatus == true && item.iProductoID == 1
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintNomProductoID,
                                    vchInterface = item.vchDescripcion

                                };

                    results.AddRange(query);
                    //results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
        public List<Interfaces> ListarTipoCreditoPromo()
        {
            List<Interfaces> results = new List<Interfaces>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.tbl_CAT_NombreProducto
                                where item.chTipo == '1' && item.bitEstatus == true && item.iProductoID == 1
                                select new Interfaces()
                                {
                                    intInterfaceid = (Int16)item.sintNomProductoID,
                                    vchInterface = item.vchDescripcion

                                };

                    results.AddRange(query);
                    results = AgregaItemSeleccion(results);
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }

        #endregion
    }
}
