﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class ClasificacionLegalDataAccess
    {
        #region Consulta

        public List<ClasificacionLegal> ListadoClasificacionLegal()
        {

            List<ClasificacionLegal> results = new List<ClasificacionLegal>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatClasificacionLegal()
                                select new ClasificacionLegal()
                                {
                                    sintClasificaLegID = item.sintClasificaLegID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
