﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class ClientesDataAccess
    {



        public List<clsDatosPersona> ListadoInterfacesPersonas(interfacePersona oInterfaces)
        {

            List<clsDatosPersona> results = new List<clsDatosPersona>();

            try
            {
                using (InterfacesDataContext dc = new InterfacesDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListaLayoutBajawarePersonas(oInterfaces.vchTipo, oInterfaces.vchNombre, oInterfaces.intClienteID)
                                select new clsDatosPersona()
                                {
                                    intPersonaID = int.Parse(item.CodigoCliente),
                                    strNombre = item.Nombre,
                                    strRazonSocial = item.RazonSoc,
                                    strApPaterno = item.ApPaterno,
                                    strApMaterno = item.ApMaterno,
                                    strRFC = item.RFC
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }


        #region Clientes

        public clsDatosPersona ObtieneDatosPersona(int iPersondaID, string strNegocio)
        {
            clsDatosPersona results = new clsDatosPersona();
            try
            {
                using (lnqPersonasDataContext dc = new lnqPersonasDataContext(Helper.ConnectionString()))
                {
                    var varDatosPersnoa = from item in dc.stp_getDatosClienteBajaWare(iPersondaID, strNegocio)
                                          select new clsDatosPersona()
                                          {
                                              decIngresosBrutos = item.decIngresosBrutos,
                                              intEjecutivoID = item.EjecutivoID,
                                              intEntidadGobierno = item.intEntidadGobierno,
                                              intNombreGrupoEconomico = item.NombreGrupoEconomicoID,
                                              intPersonaID = item.iPersonaId,
                                              intPersonalidadJuridica = item.sintPersonalidadJuridica,
                                              shComprobanteIngresos = item.ComprobanteIngresosID,
                                              shIndustria = item.intIndustriaID,
                                              shNumeroEmpleados = item.sintNumeroEmpleados,
                                              shRelacionAcreditado = item.RelacionAcreditadoID,
                                              shRiesgoIndustriaID = item.tintRiesgoIndustriaID, //== null ? (short)0 : short.Parse(item.RiesgoIndustria),
                                              shSectorEconomico = item.SectorEconomicoID,
                                              shSectorLaboral = item.SectorLaboralID,
                                              shSucursalID = item.intSucursalID,//== null ? (short)0 : (short)item.Sucursal,
                                              shTamanoDeudorID = item.tintTamDeudorID,
                                              shTipoAcreditadoRelacionadoID = item.TipoAcreditadoRelacionadoID,
                                              shActividadEconomicaID = item.sintActividadID,
                                              shExperienciaPagoID = item.sintExperienciaPago,
                                              //strCorreo = item.Correo,
                                              strFolioConsultaBuro = item.vchFolioConsultaBuro,
                                              strFechaConsultaBuro = item.sdatFechaConsulta.ToShortDateString(),
                                              strNombreCNBV = item.NombreCNBV,
                                              strRFC = item.vhRFC,
                                              shRiesgoFinancieroID = item.tintRiesgoFinancieroID,
                                              strTelefono = item.vchTelefono,
                                              strApMaterno = item.sApellidoMaterno,
                                              strApPaterno = item.sApellidoPaterno,
                                              strNombre = item.sPrimerNombre.Trim() == "" ? item.sNombreCompleto : item.sPrimerNombre,

                                          };
                    results = varDatosPersnoa.FirstOrDefault();
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }

            return results;
        }

        public List<clsDomicilio> ObtieneDomicilio(int iPersonaID, string strNegocio)
        {
            List<clsDomicilio> results = new List<clsDomicilio>();
            try
            {


                using (lnqPersonasDataContext dc = new lnqPersonasDataContext(Helper.ConnectionString()))
                {

                    var query = from a in dc.stp_getDomicilioPersona(iPersonaID, strNegocio)

                                select new clsDomicilio()
                                {

                                    intDomicilioID = a.iDomicilioId,
                                    shLocalidad = a.sintLocalidadID == null ? (short)0 : a.sintLocalidadID.Value,
                                    intEstado = a.iEstadoId == null ? (short)0 : a.iEstadoId.Value,
                                    //  a.FAlta,
                                    intCiudad = a.iCiudadId == null ? (short)0 : a.iCiudadId.Value,
                                    intDelegMpo = a.iMunicipioDelegacionId == null ? (short)0 : a.iMunicipioDelegacionId.Value,
                                    intPais = a.iPais == null ? (short)0 : a.iPais.Value,
                                    strCodigoPostal = a.sCodigoPostal,
                                    strEstado = a.sEstado,
                                    strCiudad = a.sCiudad,
                                    strMunicipio = a.sDelegMpo,
                                    strColonia = a.sColonia,
                                    strNumInterior = a.sNumInterior,
                                    strNumExterior = a.sNumExterior,
                                    strCalle = a.sCalle,
                                    intPersonaID = a.iPersonaId,
                                    shTipoDomicilio = (short)a.iTipoDomicilioId,
                                    strTipoDomicilio = a.sDescCatalogo

                                    //blIsFiscal = dOp.bitFiscal == null ? false : dOp.bitFiscal.Value
                                };
                    results.AddRange(query);
                }


            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        public List<CorreoPersona> ObtieneCorreos(int intPersonaID)
        {
            List<CorreoPersona> lstCorreo = new List<CorreoPersona>();
            try
            {
                using (lnqPersonasDataContext dc = new lnqPersonasDataContext(Helper.ConnectionString()))
                {

                    var result = from a in dc.tbl_Personas_Identificaciones
                                 where a.iCveTipoIdentificacion == 16 && a.iPersonaId == intPersonaID
                                 select new CorreoPersona()
                                 {
                                     intCorreoID = a.iIdentificacionId,
                                     strCorreo = a.sCampo1
                                 };

                    lstCorreo.AddRange(result);
                }
            }
            catch (Exception ex)
            {

                throw ex;
            }

            return lstCorreo;
        }

        public ServiceResult InsertaCorreos(List<CorreoPersona> lstCorreos, int intPersonaID)
        {
            ServiceResult result = new ServiceResult();

            try
            {
                using (lnqPersonasDataContext dc = new lnqPersonasDataContext(Helper.ConnectionString()))
                {

                    foreach (var item in lstCorreos)
                    {
                        if (item.intCorreoID != 0)
                        {
                            var res = from a in dc.tbl_Personas_Identificaciones
                                      where a.iIdentificacionId == item.intCorreoID
                                      select a;
                            res.First().sCampo1 = item.strCorreo;
                        }
                        else
                        {
                            var maxID = (from a in dc.tbl_Personas_Identificaciones select a.iIdentificacionId).Max() + 1;
                            ;
                            tbl_Personas_Identificaciones tbl = new tbl_Personas_Identificaciones()
                            {
                                iIdentificacionId = maxID,
                                iPersonaId = intPersonaID,
                                sCampo1 = item.strCorreo,
                                iCveTipoIdentificacion = 16,
                                FAlta = DateTime.Now
                            };

                            dc.tbl_Personas_Identificaciones.InsertOnSubmit(tbl);
                        }

                    }

                    dc.SubmitChanges();

                    result.ErrorMessage = "Actualizacion Exitosa";
                    result.ServiceOk = true;
                }
            }
            catch (Exception ex)
            {

                result.ErrorMessage = ex.Message;
                result.ServiceOk = false;
            }
            return result;
        }

        public ServiceResult EliminarCorreos(int intCorreoID)
        {
            ServiceResult result = new ServiceResult();

            try
            {
                using (lnqPersonasDataContext dc = new lnqPersonasDataContext(Helper.ConnectionString()))
                {
                    var res = from a in dc.tbl_Personas_Identificaciones
                              where a.iIdentificacionId == intCorreoID
                              select a;
                    dc.tbl_Personas_Identificaciones.DeleteOnSubmit(res.First());

                    dc.SubmitChanges();
                    result.ErrorMessage = "Eliminación Exitosa";
                    result.ServiceOk = true;
                }
            }
            catch (Exception ex)
            {
                result.ErrorMessage = ex.Message;
                result.ServiceOk = false;
            }
            return result;
        }

        public bool ExisteDomicilio(int iPersonaID, string strNegocio)
        {
            try
            {
                using (lnqPersonasDataContext dc = new lnqPersonasDataContext(Helper.ConnectionString()))
                {

                    var query = from a in dc.tbl_Personas_Domicilios where a.iPersonaId == iPersonaID && a.iTipoDomicilioId == (strNegocio == "E" ? 2 : 1) select a;

                    if (query.Count() == 0)
                        return false;
                    else
                        return true;
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        public ServiceResult InsertaDomicilio(clsDomicilio clsDom)
        {
            ServiceResult result = new ServiceResult();

            clsDomicilio results = new clsDomicilio();
            try
            {


                string strMsj = String.Empty;


                using (lnqPersonasDataContext dc = new lnqPersonasDataContext(Helper.ConnectionString()))
                {

                    if (clsDom.intDomicilioID != 0)
                    {
                        var query = from a in dc.tbl_Personas_Domicilios
                                    // join tDom in dc.tbl_sistema_catalogos on a.iTipoDomicilioId  equals  tDom.
                                    where a.iDomicilioId == clsDom.intDomicilioID
                                    select a;

                        query.First().sintLocalidadID = clsDom.shLocalidad;
                        query.First().iEstadoId = clsDom.intEstado;

                        query.First().iCiudadId = clsDom.intCiudad;
                        query.First().iMunicipioDelegacionId = clsDom.intDelegMpo;
                        query.First().iPais = clsDom.intPais;
                        query.First().sCodigoPostal = clsDom.strCodigoPostal;
                        query.First().sEstado = clsDom.strEstado;
                        query.First().sCiudad = clsDom.strCiudad;
                        query.First().sDelegMpo = clsDom.strMunicipio;
                        query.First().sColonia = clsDom.strColonia;
                        query.First().sNumExterior = clsDom.strNumExterior;
                        query.First().sNumInterior = clsDom.strNumInterior;
                        query.First().sCalle = clsDom.strCalle;
                        //query.First().iPersonaId = clsDom.intPersonaID;
                        //query.First().iTipoDomicilioId = clsDom.shTipoDomicilio;
                        strMsj = "Se Actualizo el Domicilio";
                    }
                    else
                    {
                        var idDom = (from a in dc.tbl_Personas_Domicilios select a.iDomicilioId).Max() + 1;
                        tbl_Personas_Domicilios tbl = new tbl_Personas_Domicilios();

                        tbl.iDomicilioId = idDom;
                        tbl.sintLocalidadID = clsDom.shLocalidad;
                        tbl.iEstadoId = clsDom.intEstado;
                        tbl.FAlta = DateTime.Now;
                        tbl.iCiudadId = clsDom.intCiudad;
                        tbl.iMunicipioDelegacionId = clsDom.intDelegMpo;
                        tbl.iPais = clsDom.intPais;
                        tbl.sCodigoPostal = clsDom.strCodigoPostal;
                        tbl.sEstado = clsDom.strEstado;
                        tbl.sCiudad = clsDom.strCiudad;
                        tbl.sDelegMpo = clsDom.strMunicipio;
                        tbl.sColonia = clsDom.strColonia;
                        tbl.sNumExterior = clsDom.strNumExterior;
                        tbl.sNumInterior = clsDom.strNumInterior;
                        tbl.sCalle = clsDom.strCalle;
                        tbl.iPersonaId = clsDom.intPersonaID;
                        tbl.iTipoDomicilioId = clsDom.shTipoDomicilio;
                        dc.tbl_Personas_Domicilios.InsertOnSubmit(tbl);

                        strMsj = "Se Inserto el Domicilio";
                    }

                    dc.SubmitChanges();
                }


                result.ErrorMessage = strMsj;
                result.ServiceOk = true;

            }
            catch (Exception ex)
            {
                result.ErrorMessage = ex.Message;
                result.ServiceOk = false;
            }

            return result;
        }


        /// <summary>
        /// Inserta los datos de la persona
        /// </summary>
        /// <param name="clsDatPersonas"></param>
        /// <param name="shAreaCaptura"></param>
        /// <returns></returns>
        public ServiceResult InsertaDatosPersonas(clsDatosPersona clsDatPersonas, short shAreaCaptura)
        {
            ServiceResult result = new ServiceResult();
            try
            {
                using (lnqPersonasDataContext dc = new lnqPersonasDataContext(Helper.ConnectionString()))
                {
                    string strMsj = "";
                    short? shError = 0;

                    dc.stp_setDatosClienteBajaWare(shAreaCaptura,
                                                    clsDatPersonas.strNegocio,
                                                    clsDatPersonas.intPersonaID,
                                                    clsDatPersonas.strNombre,
                                                    clsDatPersonas.strApPaterno,
                                                    clsDatPersonas.strApMaterno,
                                                    clsDatPersonas.strRFC,
                                                    clsDatPersonas.shActividadEconomicaID,
                                                    (byte)clsDatPersonas.shTamanoDeudorID,
                                                    (byte)clsDatPersonas.shTipoAcreditadoRelacionadoID,
                                                    (byte)clsDatPersonas.shRiesgoIndustriaID,
                                                    (byte)clsDatPersonas.shRiesgoFinancieroID,
                                                    (byte)clsDatPersonas.shExperienciaPagoID,
                                                    clsDatPersonas.intEjecutivoID,
                                                    clsDatPersonas.strTelefono,
                                                    clsDatPersonas.shSucursalID,
                                                    clsDatPersonas.shIndustria,
                                                    (byte)clsDatPersonas.intEntidadGobierno,
                                                    clsDatPersonas.decExperienciaPago,
                                                    (byte)clsDatPersonas.intNombreGrupoEconomico,
                                                    (byte)clsDatPersonas.intPersonalidadJuridica,
                                                    clsDatPersonas.shSectorEconomico,
                                                    clsDatPersonas.shNumeroEmpleados,
                                                    clsDatPersonas.decIngresosBrutos,
                                                    clsDatPersonas.strFolioConsultaBuro,
                                                    clsDatPersonas.strFechaConsultaBuro,
                                                    clsDatPersonas.shComprobanteIngresos,
                                                    (byte)clsDatPersonas.shSectorLaboral,
                                                    clsDatPersonas.strNombreCNBV,
                                                    (byte)clsDatPersonas.shRelacionAcreditado,
                                                    ref shError,
                                                    ref strMsj
                                                    );



                    result.ErrorMessage = strMsj;
                    result.ServiceOk = shError == 0 ? true : false;
                }

            }
            catch (Exception ex)
            {
                result.ServiceOk = false;
                result.ErrorMessage = ex.Message;
                //result.ResultValue = 
                return result;
            }
            return result;
        }



        #endregion

        #region Participes
        public List<Participe> ListadoParticipes(Participe participe)
        {
            List<Participe> results = new List<Participe>();

            try
            {
                using (lnqParticipeDataContext dc = new lnqParticipeDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.sp_getParticipes(participe.iOperacionId, participe.iParticipeTipoId)
                                select new Participe()
                                {
                                    iOperacionId = item.iOperacionId,
                                    iParticipeId = item.iParticipeId,
                                    Consec = item.Consec,
                                    Nombre = item.Nombre == null ? string.Empty : item.Nombre,
                                    RFC = item.RFC == null ? string.Empty : item.RFC,
                                    pParticipacion = Convert.ToDecimal(item.pParticipacion == null ? 0 : item.pParticipacion),
                                    iTipoGarantiaId = Convert.ToInt32(item.iTipoGarantiaId == null ? 0 : item.iTipoGarantiaId),
                                    iRelacionEmpresaId = Convert.ToInt32(item.iRelacionEmpresaId == null ? 0 : item.iRelacionEmpresaId),
                                    MParticipacion = Convert.ToDecimal(item.MParticipacion == null ? 0 : item.MParticipacion),
                                    bitEstatus = item.bitEstatus == null ? true : (bool)item.bitEstatus
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        public int InsertaPersonaParticipe(int iOperacionId, int iPersonaId, string sPrimerNombre, string sSegundoNombre, string sApellidoPaterno, string sApellidoMaterno, int iCveRegimenFiscal, string RFC, int iParticipeTipoId, int UAlta)
        {

            int result = 0;


            try
            {
                using (lnqParticipeDataContext dc = new lnqParticipeDataContext(Helper.ConnectionString()))
                {
                    result = dc.sp_iPersonasParticipes(iOperacionId, iPersonaId, sPrimerNombre, sSegundoNombre, sApellidoPaterno, sApellidoMaterno, iCveRegimenFiscal, RFC, iParticipeTipoId, UAlta).ToList().First().Consec;


                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;

        }
        #endregion



        public clsDatosPersona ExistePersona(string strRFC, string strNombre)
        {
            clsDatosPersona result = new clsDatosPersona();
            try
            {
                using (lnqPersonasDataContext dc = new lnqPersonasDataContext(Helper.ConnectionString()))
                {

                    var query = from a in dc.stp_getBuscaPersona(strNombre, strRFC)
                                select new clsDatosPersona()
                                {
                                    intPersonaID = a.iPersonaId,
                                    strNombre = a.sPrimerNombre + " " + a.sSegundoNombre,
                                    strApPaterno = a.sApellidoPaterno,
                                    strApMaterno = a.sApellidoMaterno,
                                    strRFC = a.vchRFC,
                                    intPersonalidadJuridica = a.iCveRegimenFiscal
                                };

                    //if (query.Count() > 0)
                    result = query.FirstOrDefault();
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;

        }

    }
}
