﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class CreditoEmpresarialDataAccess
    {
        public List<CreditoEmpresarial> ListadoBitacoraInterface(Int32 OperacionID)
        {

            List<CreditoEmpresarial> results = new List<CreditoEmpresarial>();

            try
            {
                using (CreditoEmpresarialDataContext dc = new CreditoEmpresarialDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCreditoEmpresarialBajaWere(OperacionID)
                                select new CreditoEmpresarial()
                                {
                                    iOperacionId = item.iOperacionId,
                                    sintDestinoCredID = item.sintDestinoCredID==null?0:item.sintDestinoCredID,
                                    sintTasaRefID = item.sintTasaRefID == null ? 0 : item.sintTasaRefID,
                                    tintMetodologiaID = item.tintMetodologiaID == null ? 0 : item.tintMetodologiaID,
                                    tintTipoAltaID = item.tintTipoAltaID == null ? 0 : item.tintTipoAltaID,
                                    sintTipoCreditoID = item.sintTipoCreditoID == null ? 0 : item.sintTipoCreditoID,
                                    sintClasificaLegID = item.sintClasificaLegID == null ? -1 : item.sintClasificaLegID,
                                    tintTipoDispCredID = item.tintTipoDispCredID == null ? 0 : item.tintTipoDispCredID,
                                    tintPeriodicidadInt = item.tintPeriodicidadInt ,
                                    tintPreferenciaID =  item.tintPreferenciaID,
                                    tintTipoLinRevID = item.tintTipoLinRevID == null ? 0 : item.tintTipoLinRevID,
                                    tintTipoBajaID = item.tintTipoBajaID == null ? 0 : item.tintTipoBajaID,
                                    tintPeriodicidadCap =  item.tintPeriodicidadCap,
                                    tintOperFormaID = item.tintOperFormaID,
                                    tintExpedienCompID =  item.tintExpedienCompID,
                                    tintInfoRecuperaID =  item.tintInfoRecuperaID,
                                    iInstitutoFondea = item.sintInstitucionID == null ? 0 : (int)item.sintInstitucionID,
                                    decPorGarantiaFon=item.decPorGarantiaFon,
                                    sintClasificacionContaID = item.sintClasificacionContaID,
                                    sintTipoCreditoIDPromo=item.sintTipoCreditoIDPromo
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        public ServiceResult ActualizaCreditoEmpresarial(CreditoEmpresarial creditoEmpresarial)
        {
            ServiceResult resultado = new ServiceResult();
            try
            {
                using (CreditoEmpresarialDataContext dc = new CreditoEmpresarialDataContext(Helper.ConnectionString()))
                {
                    resultado.ResultValue = dc.sp_uCreditoEmpresarial(creditoEmpresarial.iOpcion, creditoEmpresarial.iOperacionId, creditoEmpresarial.sintDestinoCredID == 0 ? (short?)null : creditoEmpresarial.sintDestinoCredID, creditoEmpresarial.sintTasaRefID == 0 ? (short?)null : creditoEmpresarial.sintTasaRefID, creditoEmpresarial.tintMetodologiaID == 0 ? (byte?)null : (byte?)creditoEmpresarial.tintMetodologiaID, creditoEmpresarial.tintTipoAltaID == 0 ? (byte?)null : (byte?)creditoEmpresarial.tintTipoAltaID, creditoEmpresarial.sintTipoCreditoID == 0 ? (short?)null : creditoEmpresarial.sintTipoCreditoID, creditoEmpresarial.sintClasificaLegID == -1 ? (short?)null : creditoEmpresarial.sintClasificaLegID, creditoEmpresarial.tintTipoDispCredID == 0 ? (byte?)null : (byte?)creditoEmpresarial.tintTipoDispCredID, (byte?)creditoEmpresarial.tintPeriodicidadInt ,  (byte?)creditoEmpresarial.tintPreferenciaID, creditoEmpresarial.tintTipoLinRevID == 0 ? (byte?)null : (byte?)creditoEmpresarial.tintTipoLinRevID, creditoEmpresarial.tintTipoBajaID == 0 ? (byte?)null : (byte?)creditoEmpresarial.tintTipoBajaID, (byte?)creditoEmpresarial.tintPeriodicidadCap,  (byte?)creditoEmpresarial.tintOperFormaID,  (byte?)creditoEmpresarial.tintExpedienCompID,  (byte?)creditoEmpresarial.tintInfoRecuperaID, creditoEmpresarial.iInstitutoFondea==0?(int?)null:creditoEmpresarial.iInstitutoFondea, creditoEmpresarial.sintClasificacionContaID ,creditoEmpresarial.sintTipoCreditoIDPromo,creditoEmpresarial.decPorGarantiaFon);
                    resultado.ServiceOk=true;
                }
            }
            catch (Exception ex)
            {
                resultado.ServiceOk = false;
                throw ex;
            }
               
                
            return resultado;
        }
    }
}
