﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.DataAccess.Context;

namespace HCM.DataAccess
{
    public class CreditoHipotecarioDataAccess
    {
        public List<CreditoHipotecario> ListadoCreditoHipotecario(CreditoHipotecario creditoHipotecario)
        {

            List<CreditoHipotecario> results = new List<CreditoHipotecario>();

            try
            {
                using (lnqCreditoHipotecarioDataContext dc = new lnqCreditoHipotecarioDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.sp_getCreditoHipotecario(creditoHipotecario.iOperacionId)
                                select new CreditoHipotecario()
                                {

                                    iOperacionId = item.iOperacionId == null ? 0 : item.iOperacionId,
	                                iPersonaId=item.iPersonaId == null ? 0 :item.iPersonaId,
	                                sintDestinoCredID=item.sintDestinoCredID == null ? 0 :item.sintDestinoCredID,
	                                sintTasaRefID=item.sintTasaRefID == null ? 0 :item.sintTasaRefID,
	                                tintTipoAltaID=item.tintTipoAltaID == null ? 0 :item.tintTipoAltaID,
	                                tintTipoBajaID=item.tintTipoBajaID == null ? 0 :item.tintTipoBajaID,
	                                sintTipoCreditoID=item.sintTipoCreditoID == null ? 0 :item.sintTipoCreditoID,
                                    //dpConcedido=item.dpConcedido == null ? 0 :item.dpConcedido,
	                                dMProyecto=item.dMProyecto == null ? 0 :item.dMProyecto,
	                                sintEntAsegID=item.sintEntAsegID == null ? 0 :item.sintEntAsegID,
	                                sintEntidadCofinanID=item.sintEntidadCofinanID == null ? 0 :item.sintEntidadCofinanID,
	                                tintTipoSeguroID= item.tintTipoSeguroID,
	                                bitSeguroCargoCli=item.bitSeguroCargoCli == null ? false :item.bitSeguroCargoCli,
	                                tintTipoTasaIntID=item.tintTipoTasaIntID,
	                                GastosOriginacion=item.GastosOriginacion == null ? 0 :item.GastosOriginacion,
	                                TasaComisiones=item.TasaComisiones == null ? 0 :item.TasaComisiones,
                                    TasaInteres=item.TasaInteres == null ? 0 :item.TasaInteres,
                                    tintSectorLabID=item.tintSectorLabID == null ? 0 :item.tintSectorLabID,
                                    iComprobanteEmpleoId=item.iComprobanteEmpleoId == null ? 0 :item.iComprobanteEmpleoId,
                                    iEstadoId=item.iEstadoId == null ? 0 :item.iEstadoId,
                                    iDelegMpoId=item.iMunicipioDelegacionId == null ? 0 :item.iMunicipioDelegacionId,
                                    sCodigoPostal=item.sCodigoPostal == null ? string.Empty :item.sCodigoPostal,
                                    decImporteIngreso = item.decImporteIngreso == null ? 0 : item.decImporteIngreso,
                                    BitConvenio=item.bitConvenio==null?false:item.bitConvenio
                                   


                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        public ServiceResult ActualizaCreditoHipotecario(CreditoHipotecario creditoHipotecario)
        {
            ServiceResult resultado = new ServiceResult();
            try
            {
                using (lnqCreditoHipotecarioDataContext dc = new lnqCreditoHipotecarioDataContext(Helper.ConnectionString()))
                {
                    resultado.ResultValue = dc.sp_uCreditoHipotecario(creditoHipotecario.iOpcion, creditoHipotecario.iOperacionId, creditoHipotecario.iPersonaId, (short?)creditoHipotecario.sintDestinoCredID, (short?)creditoHipotecario.sintTasaRefID, (byte?)creditoHipotecario.tintTipoAltaID, (byte?)creditoHipotecario.tintTipoBajaID, (short?)creditoHipotecario.sintTipoCreditoID/*, creditoHipotecario.dpConcedido*/, creditoHipotecario.dMProyecto, (short?)creditoHipotecario.sintEntAsegID, (short?)creditoHipotecario.sintEntidadCofinanID,(byte?) creditoHipotecario.tintTipoSeguroID, creditoHipotecario.bitSeguroCargoCli,(byte?) creditoHipotecario.tintTipoTasaIntID, creditoHipotecario.GastosOriginacion, creditoHipotecario.TasaComisiones, creditoHipotecario.TasaInteres,(byte?) creditoHipotecario.tintSectorLabID, creditoHipotecario.iComprobanteEmpleoId, creditoHipotecario.sCodigoPostal, creditoHipotecario.iEstadoId, creditoHipotecario.iDelegMpoId, creditoHipotecario.decImporteIngreso,creditoHipotecario.BitConvenio);
                }
            }
            catch (Exception ex)
            {
                resultado.ServiceOk = false;
                throw ex;
            }


            return resultado;
        }
        public clsDomicilio ObtieneEstadoMunicipio(string CodigoPostal)
        {
            clsDomicilio domicilio = new clsDomicilio();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = (from item in dc.tbl_sistema_sepomex
                                 where item.sCodigoPostal == CodigoPostal
                                 select new clsDomicilio()
                                 {
                                     strCodigoPostal=item.sCodigoPostal,
                                     intEstado = item.iClaveEstado,
                                     intDelegMpo = item.iClaveMunicipio
                                 }).Distinct();

                    if(query.Count()>0)
                         domicilio = (clsDomicilio)query.ToList()[0];
                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return domicilio;
        }
    }
}
