﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class DestinoCreditoDataAccess
    {
        #region Consulta

        public List<DestinoCredito> ListadoDestinoCredito()
        {

            List<DestinoCredito> results = new List<DestinoCredito>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatDestinoCredito()
                                select new DestinoCredito()
                                {
                                    sintDestinoCredID = item.sintDestinoCredID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
