﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class DisposicionCreditoDataAccess
    {
        #region Consulta

        public List<DisposicionCredito> ListadoDisposicionCredito()
        {

            List<DisposicionCredito> results = new List<DisposicionCredito>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatDispCredito()
                                select new DisposicionCredito()
                                {
                                    tintTipoDispCredID = item.tintTipoDispCredID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
