﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class GarantiasDataAcces
    {
        public GarantiasDataAcces()
        {
           
        }

        public int  InsertarEditar(Garantia garantia)
        {
            int resultado = 0;
            try
            {
                using (lnqGarantiasDataContext dc = new lnqGarantiasDataContext(Helper.ConnectionString()))
                {
                    resultado =(int) dc.sp_iOperacionesGarantia(garantia.iGarantiaId, 
                                                                garantia.iOperacionId, 
                                                                garantia.sintTipoGarantiaID, 
                                                                garantia.nValorComercial,
                                                                garantia.sintMonedaID, 
                                                                garantia.datFechaValuacion, 
                                                                garantia.sintGradoPrelacion, 
                                                                garantia.vchDescripcion, 
                                                                garantia.bitBursatilidad, 
                                                                garantia.bitLiquidez,
                                                                garantia.sintInstitucionID, 
                                                                garantia.UAlta, 
                                                                garantia.sintIndividual).First().iGarantiasId;
                }
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return resultado;
        }

        public List<Garantia> ListadoGarantias(int? iOperacionId, int individual)
        {

            List<Garantia> results = new List<Garantia>();

            try
            {
                using (lnqGarantiasDataContext dc = new lnqGarantiasDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.sp_getOperacionesGarantia(iOperacionId,individual)
                                select new Garantia()
                                {
                                    iGarantiaId=item.iGarantiasId,
                                    iOperacionId=item.iOperacionId,
                                    nValorComercial = item.nValorComercial == null ? 0 : item.nValorComercial,
                                    UAlta = item.UAlta == null ? 0 : item.UAlta,
                                    sintTipoGarantiaID =  (Int16)(item.sintTipoGarantiaID == null ? -1 :item.sintTipoGarantiaID),
                                    strTipoGrantia = item.strTipoGrantia,
                                    sintMonedaID = (Int16)(item.sintMonedaID == null ? -1 : item.sintMonedaID),
                                    strMoneda=item.strMoneda,
                                    datFechaValuacion = (DateTime)(item.datFechaValuacion == null ? DateTime.Now : item.datFechaValuacion),
                                    sintGradoPrelacion = (Int16)(item.sintGradoPrelacion == null ? 0 : item.sintGradoPrelacion),
                                    vchDescripcion = item.vchDescripcion == null ? string.Empty : item.vchDescripcion,
                                    bitBursatilidad = (bool)(item.bitBursatilidad == null ? false : item.bitBursatilidad),
                                    bitLiquidez = (bool)(item.bitLiquidez == null ? false : item.bitLiquidez),
                                    sintInstitucionID = (Int16)(item.sintInstitucionID == null ? -1 : item.sintInstitucionID),
                                    strInstitucion=item.strInstitucion
};
                 
                        results.AddRange(query);
                  

                }

            }
            catch (Exception ex)
            {

                throw ex;
            }



            //if (results.Count == 0)
            //    results.Add(new Garantia());

            return results;
        }
    }
}
