﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class InformacionRecuperacionDataAccess
    {
        #region Consulta

        public List<InformacionRecuperacion> ListadoInformacionRecuperacion()
        {

            List<InformacionRecuperacion> results = new List<InformacionRecuperacion>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatInformacionRecuperacion()
                                select new InformacionRecuperacion()
                                {
                                    tintInfoRecuperaID = item.tintInfoRecuperaID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
