﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class InstitucionDataAccess
    {
        #region Consulta

        public List<Institucion> ListadoInstitucion()
        {

            List<Institucion> results = new List<Institucion>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatInstitucion()
                                select new Institucion()
                                {
                                    sintInstitucionID = item.sintInstitucionID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
