﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class MetodologiaDataAccess
    {
        #region Consulta

        public List<Metodologia> ListadoMetodologia()
        {

            List<Metodologia> results = new List<Metodologia>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatMetodologia()
                                select new Metodologia()
                                {
                                    tintMetodologiaID = item.tintMetodologiaID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
