﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HCM.BusinessEntities;
using HCM.DataAccess.Context;
using System.Data;

namespace HCM.DataAccess
{
    public class MonitoreoDatosDataAcces
    {
        public List<MonitoreoDatosBajaWare> ListadoMonitoreo(DateTime Fecha)
        {


            List<MonitoreoDatosBajaWare> results = new List<MonitoreoDatosBajaWare>();

            try
            {
                using (lnqMonitoreoCargasDataContext dc = new lnqMonitoreoCargasDataContext(Helper.ConnectionString()))
                {
                    DataSet ds = new DataSet();

                    dc.CommandTimeout = 100000;

                    var query = from item in dc.stp_getMonitoreoPersonas()
                                select new MonitoreoDatosBajaWare()
                                {
                                    pertotal = item.total,
                                    perNombreCliente = item.NombreCliente,
                                    perCodigoCliente_sys = item.CodigoCliente_sys,
                                    perRFC = item.RFC,
                                    perActividadEconomica = item.ActividadEconomica,
                                    perTamanoDeudor = item.TamanoDeudor,
                                    perTipoAcreditadoRelacionado = item.TipoAcreditadoRelacionado,
                                    perDomicilio = item.Domicilio,
                                    perEjecutivo = item.Ejecutivo,
                                    perTelefono = item.Telefono,
                                    perCorreo = item.Correo,
                                    perSucursal = item.Sucursal,
                                    perIndustria = item.Industria,
                                    perEntidadGobierno_sys = item.EntidadGobierno_sys,
                                    perRiesgoIndustria = item.RiesgoIndustria,
                                    perRiesgoFinanciero = item.RiesgoFinanciero,
                                    perExperienciaPago = item.ExperienciaPago,
                                    perNombreGrupoEconomico_sys = item.NombreGrupoEconomico_sys,
                                    perPersonalidadJuridica = item.PersonalidadJuridica,
                                    perSectorEconomico = item.SectorEconomico,
                                    perNumeroEmpleados = item.NumeroEmpleados,
                                    perIngresosBrutos = item.IngresosBrutos,
                                    perFolioConsultaBuro = item.FolioConsultaBuro,
                                    perComprobanteIngresos = item.ComprobanteIngresos,
                                    perSectorLaboral = item.SectorLaboral,
                                    perLocalidad = item.Localidad,
                                    perNombreCNBV = item.NombreCNBV,
                                    perEstado = item.Estado,
                                    perMunicipio = item.Municipio,
                                    perRelacionAcreditado = item.RelacionAcreditado,
                                    /**/
                                    //Ejetotal = item.total ,
                                    //EjeCodigoEjecutivo_sys = item.EjeCodigoEjecutivo_sys ,
                                    //EjeNombre = item.EjeNombre,
                                    //EjeTelefono = item.Telefono ,
                                    //EjeCorreo = item.EjeCorreo ,
                                    /**/
                                    //Avatotal = item.Avatotal ,
                                    //AvaCodigoAval_sys = item.AvaCodigoAval_sys ,
                                    //AvaNombreAval = item.AvaNombreAval ,
                                    //AvaRFC = item.AvaRFC ,
                                    //AvaDomicilio = item.AvaDomicilio ,
                                    //AvaPersonalidadJuridica = item.AvaPersonalidadJuridica,
                                    //AvaTipoAval = item.AvaTipoAval ,
                                    //AvaIndustria = item.AvaIndustria ,
                                    //AvaRiesgoIndustria = item.AvaRiesgoIndustria ,
                                    //AvaRiesgoFinanciero = item.AvaRiesgoFinanciero ,
                                    //AvaRiesgoExperienciaPago = item.AvaRiesgoExperienciaPago ,
                                    //AvaTipo = item.AvaTipo ,
                                    /**/
                                    //Movtotal = item.Movtotal ,
                                    //MovCodigoCredito_sys = item.MovCodigoCredito_sys ,
                                    //MovTipoMovimiento_sys = item.MovTipoMovimiento_sys ,
                                    //MovMonto_sys = item.MovMonto_sys ,
                                    //MovFecha_sys = item.MovFecha_sys ,
                                    //MovTipo_sys = item.MovTipo_sys ,
                                    ///**/
                                    //GarTotal = item.GarTotal ,
                                    //GarCodigoGarantia_sys = item.GarCodigoGarantia_sys ,
                                    //GarTipoGarantia = item.GarTipoGarantia ,
                                    //GarValorGarantia = item.GarValorGarantia ,
                                    //GarMoneda = item.GarMoneda ,
                                    //GarFechaValuacion = item.GarFechaValuacion ,
                                    //GarGradoPrelacion = item.GarGradoPrelacion ,
                                    //GarDescripcion = item.GarDescripcion ,
                                    //GarBursatilidad = item.GarBursatilidad ,
                                    //GarLineaCreditoGarantiza = item.GarLineaCreditoGarantiza ,
                                    //GarLiquidez = item.GarLiquidez ,
                                    //GarBancoGarantia = item.GarBancoGarantia ,
                                    //GarTipo = item.GarTipo ,
                                    ///**/
                                    //Proytotal = item.Proytotal ,
                                    //ProyCveDeudor_sys = item.ProyCveDeudor_sys ,
                                    //ProyNombredelProyecto = item.ProyNombredelProyecto ,
                                    //ProyDescripciondelProyecto = item.ProyDescripciondelProyecto ,
                                    //ProyLinea_sys = item.ProyLinea_sys ,
                                    //ProySobrecosto_sys = item.ProySobrecosto_sys ,
                                    //ProyMontocubiertoporterceros_sys = item.ProyMontocubiertoporterceros_sys ,
                                    //ProyMesesContemplados_sys = item.ProyMesesContemplados_sys ,
                                    //ProyMesesAdicionales_sys = item.ProyMesesAdicionales_sys ,
                                    //ProyVPTotal_sys = item.ProyVPTotal_sys ,
                                    //ProyUtilidadPerdidaAcumulada_sys = item.ProyUtilidadPerdidaAcumulada_sys ,
                                    //ProyTipo = item.ProyTipo ,
                                    ///**/
                                    //Emptotal = item.Emptotal ,
                                    //EmpCodigoCliente_sys = item.EmpCodigoCliente_sys ,
                                    //EmpCodigoCredito_sys = item.EmpCodigoCredito_sys ,
                                    //EmpPorcentajeGtiaFondos_sys = item.EmpPorcentajeGtiaFondos_sys ,
                                    //EmpSaldoCapitalVigente_sys = item.EmpSaldoCapitalVigente_sys ,
                                    //EmpSaldoCapitalVencido_sys = item.EmpSaldoCapitalVencido_sys ,
                                    //EmpSaldoInteresVigente_sys = item.EmpSaldoInteresVigente_sys ,
                                    //EmpSaldoInteresVencido_sys = item.EmpSaldoInteresVencido_sys ,
                                    //EmpInteresRefinanciado_sys = item.EmpInteresRefinanciado_sys ,
                                    //EmpFechaTraspasoVigente_sys = item.EmpFechaTraspasoVigente_sys ,
                                    //EmpFechaTraspasoVencido_sys = item.EmpFechaTraspasoVencido_sys ,
                                    //EmpFechaProximaAmortizacion_sys = item.EmpFechaProximaAmortizacion_sys ,
                                    //EmpFechaAutorizacionOriginal_sys = item.EmpFechaAutorizacionOriginal_sys ,
                                    //EmpFechaDisposicion_sys = item.EmpFechaDisposicion_sys ,
                                    //EmpFechaVencimiento_sys = item.EmpFechaVencimiento_sys ,
                                    //EmpMontoOriginal_sys = item.EmpMontoOriginal_sys ,
                                    //EmpDiasMorosidad_sys = item.EmpDiasMorosidad_sys ,
                                    //EmpReestructura_sys = item.EmpReestructura_sys ,
                                    //EmpNumeroReestructura_sys = item.EmpNumeroReestructura_sys ,
                                    //EmpSituacionCredito_sys = item.EmpSituacionCredito_sys ,
                                    //EmpClasificacionContable = item.EmpClasificacionContable ,
                                    //EmpTipoCredito_sys = item.EmpTipoCredito_sys ,
                                    //EmpMoneda_sys = item.EmpMoneda_sys ,
                                    //EmpDestinoCredito = item.EmpDestinoCredito ,
                                    //EmpTasaReferencia = item.EmpTasaReferencia ,
                                    //EmpClasificacionLegal = item.EmpClasificacionLegal ,
                                    //EmpTasaInteresBruta_sys = item.EmpTasaInteresBruta_sys ,
                                    //EmpMontoLinea_sys = item.EmpMontoLinea_sys ,
                                    //EmpNumeroAgrupacion_sys = item.EmpNumeroAgrupacion_sys ,
                                    //EmpFrecuenciaRevisionTasa_sys = item.EmpFrecuenciaRevisionTasa_sys ,
                                    //EmpNumeroLinea_sys = item.EmpNumeroLinea_sys ,
                                    //EmpOperacionFormalizada = item.EmpOperacionFormalizada ,
                                    //EmpInformacionRecuperacion = item.EmpInformacionRecuperacion ,
                                    //EmpExpedienteCompleto = item.EmpExpedienteCompleto ,
                                    //EmpMesesVencidos_sys = item.EmpMesesVencidos_sys ,
                                    //EmpMetodologia = item.EmpMetodologia ,
                                    //EmpParticipacionFederal_sys = item.EmpParticipacionFederal_sys ,
                                    //EmpGarantiaPersonal = item.EmpGarantiaPersonal ,
                                    //EmpFuenteFondeo_sys = item.EmpFuenteFondeo_sys ,
                                    //EmpInteresCarteraVencida_sys = item.EmpInteresCarteraVencida_sys ,
                                    //EmpTipoAlta = item.EmpTipoAlta ,
                                    //EmpDisposicionCredito = item.EmpDisposicionCredito ,
                                    //EmpAjusteTasa_sys = item.EmpAjusteTasa_sys ,
                                    //EmpImporteApoyoBancaDesarrollo_sys = item.EmpImporteApoyoBancaDesarrollo_sys ,
                                    //EmpInstitutoFondea = item.EmpInstitutoFondea ,
                                    //EmpComisionesCobradas_sys = item.EmpComisionesCobradas_sys ,
                                    //EmpNumeroDisposicion_sys = item.EmpNumeroDisposicion_sys ,
                                    //EmpImporteCreditoDispuesto_sys = item.EmpImporteCreditoDispuesto_sys ,
                                    //EmpPagoExigible_sys = item.EmpPagoExigible_sys ,
                                    //EmpPagoCliente_sys = item.EmpPagoCliente_sys ,
                                    //EmpInteresPagado_sys = item.EmpInteresPagado_sys ,
                                    //EmpComisionesDevengadas_sys = item.EmpComisionesDevengadas_sys ,
                                    //EmpDiasVencidos_sys = item.EmpDiasVencidos_sys ,
                                    //EmpTipoBaja = item.EmpTipoBaja ,
                                    //EmpImporteQuebranto_sys = item.EmpImporteQuebranto_sys ,
                                    //EmpSaldoPrincipalFinal_sys = item.EmpSaldoPrincipalFinal_sys ,
                                    //EmpSaldoInicial_sys = item.EmpSaldoInicial_sys ,
                                    //EmpPeriodicidadCapital = item.EmpPeriodicidadCapital ,
                                    //EmpPeriodicidadInteres = item.EmpPeriodicidadInteres ,
                                    //EmpCodigoCreditoReestructurado_sys = item.EmpCodigoCreditoReestructurado_sys ,
                                    //EmpProductoComercial = item.EmpProductoComercial ,
                                    //EmpSaldoPromedio_sys = item.EmpSaldoPromedio_sys ,
                                    //EmpInteresDevengado_sys = item.EmpInteresDevengado_sys ,
                                    //EmpComision_sys = item.EmpComision_sys ,
                                    //EmpTipoCreditoR04A = item.EmpTipoCreditoR04A ,
                                    //EmpPosicion = item.EmpPosicion ,
                                    //EmpTipoLinea = item.EmpTipoLinea ,
                                    //EmpExposicionIncumplimiento = item.EmpExposicionIncumplimiento ,
                                    ///**/
                                    //CGTotal = item.CGTotal ,
                                    //CGCodigoCredito = item.CGCodigoCredito ,
                                    //CGPorcentaje = item.CGPorcentaje ,
                                    //CGTipo = item.CGTipo ,
                                    ///**/
                                    //CATotal = item.CATotal ,
                                    //CACodigoAval = item.CACodigoAval ,
                                    //CACodigoCredito = item.CACodigoCredito ,
                                    //CAPorcentaje = item.CAPorcentaje ,
                                    //CATipo = item.CATipo 
                                };
                    MonitoreoDatosBajaWare resu = query.First();
                    var query2 = from item in dc.stp_getMonitoreoEjecutivos()
                                 select new MonitoreoDatosBajaWare()
                   {
                       Ejetotal = item.total,
                       EjeCodigoEjecutivo_sys = item.CodigoEjecutivo,
                       EjeNombre = item.Nombre,
                       EjeTelefono = item.Telefono,
                       EjeCorreo = item.Correo,
                   };

                    MonitoreoDatosBajaWare res2 = query2.First();
                    resu.Ejetotal = res2.Ejetotal;
                    resu.EjeCodigoEjecutivo_sys = res2.EjeCodigoEjecutivo_sys;
                    resu.EjeNombre = res2.EjeNombre;
                    resu.EjeTelefono = res2.EjeTelefono;
                    resu.EjeCorreo = res2.EjeCorreo;

                    var query3 = from item in dc.stp_getMonitoreoAval()
                                 select new MonitoreoDatosBajaWare()
                                 {
                                     Avatotal = item.total,
                                     AvaCodigoAval_sys = item.CodigoAval_sys,
                                     AvaNombreAval = item.NombreAval,
                                     AvaRFC = item.RFC,
                                     AvaDomicilio = item.Domicilio,
                                     AvaPersonalidadJuridica = item.PersonalidadJuridica,
                                     AvaTipoAval = item.TipoAval,
                                     AvaIndustria = item.Industria,
                                     AvaRiesgoIndustria = item.RiesgoIndustria,
                                     AvaRiesgoFinanciero = item.RiesgoFinanciero,
                                     AvaRiesgoExperienciaPago = item.RiesgoExperienciaPago,
                                     AvaTipo = item.Tipo,
                                 };
                    MonitoreoDatosBajaWare res3 = query3.First();
                    resu.Avatotal = res3.Avatotal;
                    resu.AvaCodigoAval_sys = res3.AvaCodigoAval_sys;
                    resu.AvaNombreAval = res3.AvaNombreAval;
                    resu.AvaRFC = res3.AvaRFC;
                    resu.AvaDomicilio = res3.AvaDomicilio;
                    resu.AvaPersonalidadJuridica = res3.AvaPersonalidadJuridica;
                    resu.AvaTipoAval = res3.AvaTipoAval;
                    resu.AvaIndustria = res3.AvaIndustria;
                    resu.AvaRiesgoIndustria = res3.AvaRiesgoIndustria;
                    resu.AvaRiesgoFinanciero = res3.AvaRiesgoFinanciero;
                    resu.AvaRiesgoExperienciaPago = res3.AvaRiesgoExperienciaPago;
                    resu.AvaTipo = res3.AvaTipo;

                    var query4 = from item in dc.stp_getMonitoreoMovContables(Fecha)
                                 select new MonitoreoDatosBajaWare()
                                 {
                                     Movtotal = item.total,
                                     MovCodigoCredito_sys = item.CodigoCredito_sys,
                                     MovTipoMovimiento_sys = item.TipoMovimiento_sys,
                                     MovMonto_sys = item.Monto_sys,
                                     MovFecha_sys = item.Fecha_sys,
                                     MovTipo_sys = item.Tipo_sys,
                                 };

                    MonitoreoDatosBajaWare res4 = query4.First();
                    resu.Movtotal = res4.Movtotal;
                    resu.MovCodigoCredito_sys = res4.MovCodigoCredito_sys;
                    resu.MovTipoMovimiento_sys = res4.MovTipoMovimiento_sys;
                    resu.MovMonto_sys = res4.MovMonto_sys;
                    resu.MovFecha_sys = res4.MovFecha_sys;
                    resu.MovTipo_sys = res4.MovTipo_sys;

                    var query5 = from item in dc.stp_getMonitoreoGarantia()
                                 select new MonitoreoDatosBajaWare()
                                 {
                                     GarTotal = item.Total,
                                     GarCodigoGarantia_sys = item.CodigoGarantia_sys,
                                     GarTipoGarantia = item.TipoGarantia,
                                     GarValorGarantia = item.ValorGarantia,
                                     GarMoneda = item.Moneda,
                                     GarFechaValuacion = item.FechaValuacion,
                                     GarGradoPrelacion = item.GradoPrelacion,
                                     GarDescripcion = item.Descripcion,
                                     GarBursatilidad = item.Bursatilidad,
                                     GarLineaCreditoGarantiza = item.LineaCreditoGarantiza,
                                     GarLiquidez = item.Liquidez,
                                     GarBancoGarantia = item.BancoGarantia,
                                     GarTipo = item.Tipo,
                                 };
                    MonitoreoDatosBajaWare res5 = query5.First();
                    resu.GarTotal = res5.GarTotal;
                    resu.GarCodigoGarantia_sys = res5.GarCodigoGarantia_sys;
                    resu.GarTipoGarantia = res5.GarTipoGarantia;
                    resu.GarValorGarantia = res5.GarValorGarantia;
                    resu.GarMoneda = res5.GarMoneda;
                    resu.GarFechaValuacion = res5.GarFechaValuacion;
                    resu.GarGradoPrelacion = res5.GarGradoPrelacion;
                    resu.GarDescripcion = res5.GarDescripcion;
                    resu.GarBursatilidad = res5.GarBursatilidad;
                    resu.GarLineaCreditoGarantiza = res5.GarLineaCreditoGarantiza;
                    resu.GarLiquidez = res5.GarLiquidez;
                    resu.GarBancoGarantia = res5.GarBancoGarantia;
                    resu.GarTipo = res5.GarTipo;
                    var query6 = from item in dc.stp_getMonitoreoProyectos()
                                 select new MonitoreoDatosBajaWare()
                                 {
                                     Proytotal = item.total,
                                     ProyCveDeudor_sys = item.CveDeudor_sys,
                                     ProyNombredelProyecto = item.NombredelProyecto,
                                     ProyDescripciondelProyecto = item.DescripciondelProyecto,
                                     ProyLinea_sys = item.Linea_sys,
                                     ProySobrecosto_sys = item.Sobrecosto_sys,
                                     ProyMontocubiertoporterceros_sys = item.Montocubiertoporterceros_sys,
                                     ProyMesesContemplados_sys = item.MesesContemplados_sys,
                                     ProyMesesAdicionales_sys = item.MesesAdicionales_sys,
                                     ProyVPTotal_sys = item.VPTotal_sys,
                                     ProyUtilidadPerdidaAcumulada_sys = item.UtilidadPerdidaAcumulada_sys,
                                     ProyTipo = item.Tipo,
                                 };

                    MonitoreoDatosBajaWare res6 = query6.First();
                    resu.Proytotal = res6.Proytotal;
                    resu.ProyCveDeudor_sys = res6.ProyCveDeudor_sys;
                    resu.ProyNombredelProyecto = res6.ProyNombredelProyecto;
                    resu.ProyDescripciondelProyecto = res6.ProyDescripciondelProyecto;
                    resu.ProyLinea_sys = res6.ProyLinea_sys;
                    resu.ProySobrecosto_sys = res6.ProySobrecosto_sys;
                    resu.ProyMontocubiertoporterceros_sys = res6.ProyMontocubiertoporterceros_sys;
                    resu.ProyMesesContemplados_sys = res6.ProyMesesContemplados_sys;
                    resu.ProyMesesAdicionales_sys = res6.ProyMesesAdicionales_sys;
                    resu.ProyVPTotal_sys = res6.ProyVPTotal_sys;
                    resu.ProyUtilidadPerdidaAcumulada_sys = res6.ProyUtilidadPerdidaAcumulada_sys;
                    resu.ProyTipo = res6.ProyTipo;

                    var query7 = from item in dc.stp_getMonitoreoCredEmpresarial(Fecha)
                                 select new MonitoreoDatosBajaWare()
                                 {
                                     Emptotal = item.total,
                                     EmpCodigoCliente_sys = item.CodigoCliente_sys,
                                     EmpCodigoCredito_sys = item.CodigoCredito_sys,
                                     EmpPorcentajeGtiaFondos_sys = item.PorcentajeGtiaFondos_sys,
                                     EmpSaldoCapitalVigente_sys = item.SaldoCapitalVigente_sys,
                                     EmpSaldoCapitalVencido_sys = item.SaldoCapitalVencido_sys,
                                     EmpSaldoInteresVigente_sys = item.SaldoInteresVigente_sys,
                                     EmpSaldoInteresVencido_sys = item.SaldoInteresVencido_sys,
                                     EmpInteresRefinanciado_sys = item.InteresRefinanciado_sys,
                                     EmpFechaTraspasoVigente_sys = item.FechaTraspasoVigente_sys,
                                     EmpFechaTraspasoVencido_sys = item.FechaTraspasoVencido_sys,
                                     EmpFechaProximaAmortizacion_sys = item.FechaProximaAmortizacion_sys,
                                     EmpFechaAutorizacionOriginal_sys = item.FechaAutorizacionOriginal_sys,
                                     EmpFechaDisposicion_sys = item.FechaDisposicion_sys,
                                     EmpFechaVencimiento_sys = item.FechaVencimiento_sys,
                                     EmpMontoOriginal_sys = item.MontoOriginal_sys,
                                     EmpDiasMorosidad_sys = item.DiasMorosidad_sys,
                                     EmpReestructura_sys = item.Reestructura_sys,
                                     EmpNumeroReestructura_sys = item.NumeroReestructura_sys,
                                     EmpSituacionCredito_sys = item.SituacionCredito_sys,
                                     EmpClasificacionContable = item.ClasificacionContable,
                                     EmpTipoCredito_sys = item.TipoCredito_sys,
                                     EmpMoneda_sys = item.Moneda_sys,
                                     EmpDestinoCredito = item.DestinoCredito,
                                     EmpTasaReferencia = item.TasaReferencia,
                                     EmpClasificacionLegal = item.ClasificacionLegal,
                                     EmpTasaInteresBruta_sys = item.TasaInteresBruta_sys,
                                     EmpMontoLinea_sys = item.MontoLinea_sys,
                                     EmpNumeroAgrupacion_sys = item.NumeroAgrupacion_sys,
                                     EmpFrecuenciaRevisionTasa_sys = item.FrecuenciaRevisionTasa_sys,
                                     EmpNumeroLinea_sys = item.NumeroLinea_sys,
                                     EmpOperacionFormalizada = item.OperacionFormalizada,
                                     EmpInformacionRecuperacion = item.InformacionRecuperacion,
                                     EmpExpedienteCompleto = item.ExpedienteCompleto,
                                     EmpMesesVencidos_sys = item.MesesVencidos_sys,
                                     EmpMetodologia = item.Metodologia,
                                     EmpParticipacionFederal_sys = item.ParticipacionFederal_sys,
                                     EmpGarantiaPersonal = item.GarantiaPersonal,
                                     EmpFuenteFondeo_sys = item.FuenteFondeo_sys,
                                     EmpInteresCarteraVencida_sys = item.InteresCarteraVencida_sys,
                                     EmpTipoAlta = item.TipoAlta,
                                     EmpDisposicionCredito = item.DisposicionCredito,
                                     EmpAjusteTasa_sys = item.AjusteTasa_sys,
                                     EmpImporteApoyoBancaDesarrollo_sys = item.ImporteApoyoBancaDesarrollo_sys,
                                     EmpInstitutoFondea = item.InstitutoFondea,
                                     EmpComisionesCobradas_sys = item.ComisionesCobradas_sys,
                                     EmpNumeroDisposicion_sys = item.NumeroDisposicion_sys,
                                     EmpImporteCreditoDispuesto_sys = item.ImporteCreditoDispuesto_sys,
                                     EmpPagoExigible_sys = item.PagoExigible_sys,
                                     EmpPagoCliente_sys = item.PagoCliente_sys,
                                     EmpInteresPagado_sys = item.InteresPagado_sys,
                                     EmpComisionesDevengadas_sys = item.ComisionesDevengadas_sys,
                                     EmpDiasVencidos_sys = item.DiasVencidos_sys,
                                     EmpTipoBaja = item.TipoBaja,
                                     EmpImporteQuebranto_sys = item.ImporteQuebranto_sys,
                                     EmpSaldoPrincipalFinal_sys = item.SaldoPrincipalFinal_sys,
                                     EmpSaldoInicial_sys = item.SaldoInicial_sys,
                                     EmpPeriodicidadCapital = item.PeriodicidadCapital,
                                     EmpPeriodicidadInteres = item.PeriodicidadInteres,
                                     EmpCodigoCreditoReestructurado_sys = item.CodigoCreditoReestructurado_sys,
                                     EmpProductoComercial = item.ProductoComercial,
                                     EmpSaldoPromedio_sys = item.SaldoPromedio_sys,
                                     EmpInteresDevengado_sys = item.InteresDevengado_sys,
                                     EmpComision_sys = item.Comision_sys,
                                     EmpTipoCreditoR04A = item.TipoCreditoR04A,
                                     EmpPosicion = item.Posicion,
                                     EmpTipoLinea = item.TipoLinea,
                                     EmpExposicionIncumplimiento = item.ExposicionIncumplimiento,

                                 };
                    MonitoreoDatosBajaWare res7=query7.First();
                    resu.Emptotal = res7.Emptotal ;
                    resu.EmpCodigoCliente_sys = res7.EmpCodigoCliente_sys ;
                    resu.EmpCodigoCredito_sys = res7.EmpCodigoCredito_sys ;
                    resu.EmpPorcentajeGtiaFondos_sys = res7.EmpPorcentajeGtiaFondos_sys ;
                    resu.EmpSaldoCapitalVigente_sys = res7.EmpSaldoCapitalVigente_sys ;
                    resu.EmpSaldoCapitalVencido_sys = res7.EmpSaldoCapitalVencido_sys ;
                    resu.EmpSaldoInteresVigente_sys = res7.EmpSaldoInteresVigente_sys ;
                    resu.EmpSaldoInteresVencido_sys = res7.EmpSaldoInteresVencido_sys ;
                    resu.EmpInteresRefinanciado_sys = res7.EmpInteresRefinanciado_sys ;
                    resu.EmpFechaTraspasoVigente_sys = res7.EmpFechaTraspasoVigente_sys ;
                    resu.EmpFechaTraspasoVencido_sys = res7.EmpFechaTraspasoVencido_sys ;
                    resu.EmpFechaProximaAmortizacion_sys = res7.EmpFechaProximaAmortizacion_sys ;
                    resu.EmpFechaAutorizacionOriginal_sys = res7.EmpFechaAutorizacionOriginal_sys ;
                    resu.EmpFechaDisposicion_sys = res7.EmpFechaDisposicion_sys ;
                    resu.EmpFechaVencimiento_sys = res7.EmpFechaVencimiento_sys ;
                    resu.EmpMontoOriginal_sys = res7.EmpMontoOriginal_sys ;
                    resu.EmpDiasMorosidad_sys = res7.EmpDiasMorosidad_sys ;
                    resu.EmpReestructura_sys = res7.EmpReestructura_sys ;
                    resu.EmpNumeroReestructura_sys = res7.EmpNumeroReestructura_sys ;
                    resu.EmpSituacionCredito_sys = res7.EmpSituacionCredito_sys ;
                    resu.EmpClasificacionContable = res7.EmpClasificacionContable ;
                    resu.EmpTipoCredito_sys = res7.EmpTipoCredito_sys ;
                    resu.EmpMoneda_sys = res7.EmpMoneda_sys ;
                    resu.EmpDestinoCredito = res7.EmpDestinoCredito ;
                    resu.EmpTasaReferencia = res7.EmpTasaReferencia ;
                    resu.EmpClasificacionLegal = res7.EmpClasificacionLegal ;
                    resu.EmpTasaInteresBruta_sys = res7.EmpTasaInteresBruta_sys ;
                    resu.EmpMontoLinea_sys = res7.EmpMontoLinea_sys ;
                    resu.EmpNumeroAgrupacion_sys = res7.EmpNumeroAgrupacion_sys ;
                    resu.EmpFrecuenciaRevisionTasa_sys = res7.EmpFrecuenciaRevisionTasa_sys ;
                    resu.EmpNumeroLinea_sys = res7.EmpNumeroLinea_sys ;
                    resu.EmpOperacionFormalizada = res7.EmpOperacionFormalizada ;
                    resu.EmpInformacionRecuperacion = res7.EmpInformacionRecuperacion ;
                    resu.EmpExpedienteCompleto = res7.EmpExpedienteCompleto ;
                    resu.EmpMesesVencidos_sys = res7.EmpMesesVencidos_sys ;
                    resu.EmpMetodologia = res7.EmpMetodologia ;
                    resu.EmpParticipacionFederal_sys = res7.EmpParticipacionFederal_sys ;
                    resu.EmpGarantiaPersonal = res7.EmpGarantiaPersonal ;
                    resu.EmpFuenteFondeo_sys = res7.EmpFuenteFondeo_sys ;
                    resu.EmpInteresCarteraVencida_sys = res7.EmpInteresCarteraVencida_sys ;
                    resu.EmpTipoAlta = res7.EmpTipoAlta ;
                    resu.EmpDisposicionCredito = res7.EmpDisposicionCredito ;
                    resu.EmpAjusteTasa_sys = res7.EmpAjusteTasa_sys ;
                    resu.EmpImporteApoyoBancaDesarrollo_sys = res7.EmpImporteApoyoBancaDesarrollo_sys ;
                    resu.EmpInstitutoFondea = res7.EmpInstitutoFondea ;
                    resu.EmpComisionesCobradas_sys = res7.EmpComisionesCobradas_sys ;
                    resu.EmpNumeroDisposicion_sys = res7.EmpNumeroDisposicion_sys ;
                    resu.EmpImporteCreditoDispuesto_sys = res7.EmpImporteCreditoDispuesto_sys ;
                    resu.EmpPagoExigible_sys = res7.EmpPagoExigible_sys ;
                    resu.EmpPagoCliente_sys = res7.EmpPagoCliente_sys ;
                    resu.EmpInteresPagado_sys = res7.EmpInteresPagado_sys ;
                    resu.EmpComisionesDevengadas_sys = res7.EmpComisionesDevengadas_sys ;
                    resu.EmpDiasVencidos_sys = res7.EmpDiasVencidos_sys ;
                    resu.EmpTipoBaja = res7.EmpTipoBaja ;
                    resu.EmpImporteQuebranto_sys = res7.EmpImporteQuebranto_sys ;
                    resu.EmpSaldoPrincipalFinal_sys = res7.EmpSaldoPrincipalFinal_sys ;
                    resu.EmpSaldoInicial_sys = res7.EmpSaldoInicial_sys ;
                    resu.EmpPeriodicidadCapital = res7.EmpPeriodicidadCapital ;
                    resu.EmpPeriodicidadInteres = res7.EmpPeriodicidadInteres ;
                    resu.EmpCodigoCreditoReestructurado_sys = res7.EmpCodigoCreditoReestructurado_sys ;
                    resu.EmpProductoComercial = res7.EmpProductoComercial ;
                    resu.EmpSaldoPromedio_sys = res7.EmpSaldoPromedio_sys ;
                    resu.EmpInteresDevengado_sys = res7.EmpInteresDevengado_sys ;
                    resu.EmpComision_sys = res7.EmpComision_sys ;
                    resu.EmpTipoCreditoR04A = res7.EmpTipoCreditoR04A ;
                    resu.EmpPosicion = res7.EmpPosicion ;
                    resu.EmpTipoLinea = res7.EmpTipoLinea ;
                    resu.EmpExposicionIncumplimiento = res7.EmpExposicionIncumplimiento ;

                    var query8= from item in dc.stp_getMonitoreoCredGarantia()
                                select new  MonitoreoDatosBajaWare()
                                {
                                    CGTotal = item.Total,
                                    CGCodigoCredito = item.CodigoCredito,
                                    CGPorcentaje = item.Porcentaje,
                                    CGTipo = item.Tipo,
                                };
                    MonitoreoDatosBajaWare res8 = query8.First();
                    resu.CGTotal = res8.CGTotal;
                    resu.CGCodigoCredito = res8.CGCodigoCredito;
                    resu.CGPorcentaje = res8.CGPorcentaje;
                    resu.CGTipo = res8.CGTipo;

                    var query9 = from item in dc.stp_getMonitoreoCredAval()
                                 select new MonitoreoDatosBajaWare()
                                 {
                                     CATotal = item.total,
                                     CACodigoAval = item.CodigoAval ,
                                     CACodigoCredito = item.CodigoCredito ,
                                     CAPorcentaje = item.Porcentaje ,
                                     CATipo = item.Tipo 
                                 };
                    MonitoreoDatosBajaWare res9 = query9.First();
                    resu.CATotal = res9.CATotal;
                    resu.CACodigoAval = res9.CACodigoAval;
                    resu.CACodigoCredito = res9.CACodigoCredito;
                    resu.CAPorcentaje = res9.CAPorcentaje;
                    resu.CGTipo = res9.CGTipo;

                    var query10 = from item in dc.stp_getLayoutCreditoHipotecario(DateTime.Now)
                                 select new MonitoreoDatosBajaWare()
                                 {
                                     Indtotal = item.Indtotal,
                                     IndOperacion = item.IndOperacion,
                                     IndCodigoCliente = item.IndCodigoCliente,
                                     IndCodigoCredito = item.IndCodigoCredito,
                                     IndSaldoCapitalVigente = item.IndSaldoCapitalVigente,
                                     IndSaldoInteresVigente = item.IndSaldoInteresVigente,
                                     IndSaldoCapitalVencido = item.IndSaldoCapitalVencido,
                                     IndSaldointeresVencido = item.IndSaldointeresVencido,
                                     IndValorVivienda = item.IndValorVivienda,
                                     IndValorOriginal = item.IndValorOriginal,
                                     IndAjusteTasaReferencia = item.IndAjusteTasaReferencia,
                                     Categoria = item.Categoria,
                                     IndComisionesCobradas = item.IndComisionesCobradas,
                                     IndGastosOriginacion = item.IndGastosOriginacion,
                                     IndMoneda = item.IndMoneda,
                                     IndMonedaOriginal = item.IndMonedaOriginal,
                                     IndMonedaReestructurado = item.IndMonedaReestructurado,
                                     IndFechaReestructura = item.IndFechaReestructura,
                                     IndFechaOtorgamiento = item.IndFechaOtorgamiento,
                                     IndFechaVencimiento = item.IndFechaVencimiento,
                                     IndFechaVencimientoReestructura = item.IndFechaVencimientoReestructura,
                                     IndFechaUltimoPagoCliente = item.IndFechaUltimoPagoCliente,
                                     IndIngresosAnuales = item.IndIngresosAnuales,
                                     IndLocalidadVivienda = item.IndLocalidadVivienda,
                                     IndMontoBonificacionAlCliente = item.IndMontoBonificacionAlCliente,
                                     IndMontoExigible = item.IndMontoExigible,
                                     IndMontoPagadoCliente = item.IndMontoPagadoCliente,
                                     IndFolioBuroCredito = item.IndFolioBuroCredito,
                                     IndNumeroAvaluo = item.IndNumeroAvaluo,
                                     IndPorcentajeAsegurado = item.IndPorcentajeAsegurado,
                                     IndValorAvaluo = item.IndValorAvaluo,
                                     IndTasaInteres = item.IndTasaInteres,
                                     IndCodigoCreditoReestructurado = item.IndCodigoCreditoReestructurado,
                                     IndEstado = item.IndEstado,
                                     IndMunicipio = item.IndMunicipio,
                                     IndSaldoPromedio = item.IndSaldoPromedio,
                                     IndInteresCarteraVencida = item.IndInteresCarteraVencida,
                                     IndMontoApoyoBancaDesarrollo = item.IndMontoApoyoBancaDesarrollo,
                                     IndMontoSucbcuenta = item.IndMontoSucbcuenta,
                                     IndMontoOriginal = item.IndMontoOriginal,
                                     IndMontoCofinanciado = item.IndMontoCofinanciado,
                                     IndMontoReestructura = item.IndMontoReestructura,
                                     IndMontoSubsidioFederal = item.IndMontoSubsidioFederal,
                                     IndProductoHipotecario = item.IndProductoHipotecario,
                                     IndSeguroCargoCliente = item.IndSeguroCargoCliente,
                                     IndSituacionCredito = item.IndSituacionCredito,
                                     IndResponsabilidadTotal = item.IndResponsabilidadTotal,
                                     IndSaldoFinalCapital = item.IndSaldoFinalCapital,
                                     IndSaldoInicialCapital = item.IndSaldoInicialCapital,
                                     IndInteresDevengado = item.IndInteresDevengado,
                                     IndTasaComisiones = item.IndTasaComisiones,
                                     IndDestino = item.IndDestino,
                                     IndEntidadSeguro = item.IndEntidadSeguro,
                                     IndEntidadCofinanciadora = item.IndEntidadCofinanciadora,
                                     IndMontoBonificacionPorDeudor = item.IndMontoBonificacionPorDeudor,
                                     IndSectorLaboral = item.IndSectorLaboral,
                                     IndTasaReferencia = item.IndTasaReferencia,
                                     IndTipoAlta = item.IndTipoAlta,
                                     IndTipoBaja = item.IndTipoBaja,
                                     IndTipoComprobacionIngresos = item.IndTipoComprobacionIngresos,
                                     IndTipoSeguro = item.IndTipoSeguro,
                                     IndTipoTasaInteres = item.IndTipoTasaInteres,
                                     IndValorBienAdjudicado = item.IndValorBienAdjudicado,
                                     IndIntExp = item.IndIntExp,
                                     IndAtr = item.IndAtr,
                                     IndMaxAtr = item.IndMaxAtr,
                                     IndPorPago = item.IndPorPago,
                                     IndPorCtlvi = item.IndPorCtlvi,
                                     IndTri = item.IndTri,
                                     IndSubcvi = item.IndSubcvi,
                                     IndSdesi = item.IndSdesi,
                                     IndConvenio = item.IndConvenio,
                                     IndPorCobPaMed = item.IndPorCobPaMed,
                                     IndPorCobPP = item.IndPorCobPP,
                                     IndComision = item.IndComision,
                                     IndTipoCreditoR04A = item.IndTipoCreditoR04A,
                                     IndNumeroAmortizacionVigente = item.IndNumeroAmortizacionVigente,
                                     IndCreditoReestructurado = item.IndCreditoReestructurado,

                                 };
                    MonitoreoDatosBajaWare res10 = query10.First();
                    resu.Indtotal = res10.Indtotal;
                    resu.IndOperacion = res10.IndOperacion;
                    resu.IndCodigoCliente = res10.IndCodigoCliente;
                    resu.IndCodigoCredito = res10.IndCodigoCredito;
                    resu.IndSaldoCapitalVigente = res10.IndSaldoCapitalVigente;
                    resu.IndSaldoInteresVigente = res10.IndSaldoInteresVigente;
                    resu.IndSaldoCapitalVencido = res10.IndSaldoCapitalVencido;
                    resu.IndSaldointeresVencido = res10.IndSaldointeresVencido;
                    resu.IndValorVivienda = res10.IndValorVivienda;
                    resu.IndValorOriginal = res10.IndValorOriginal;
                    resu.IndAjusteTasaReferencia = res10.IndAjusteTasaReferencia;
                    resu.Categoria = res10.Categoria;
                    resu.IndComisionesCobradas = res10.IndComisionesCobradas;
                    resu.IndGastosOriginacion = res10.IndGastosOriginacion;
                    resu.IndMoneda = res10.IndMoneda;
                    resu.IndMonedaOriginal = res10.IndMonedaOriginal;
                    resu.IndMonedaReestructurado = res10.IndMonedaReestructurado;
                    resu.IndFechaReestructura = res10.IndFechaReestructura;
                    resu.IndFechaOtorgamiento = res10.IndFechaOtorgamiento;
                    resu.IndFechaVencimiento = res10.IndFechaVencimiento;
                    resu.IndFechaVencimientoReestructura = res10.IndFechaVencimientoReestructura;
                    resu.IndFechaUltimoPagoCliente = res10.IndFechaUltimoPagoCliente;
                    resu.IndIngresosAnuales = res10.IndIngresosAnuales;
                    resu.IndLocalidadVivienda = res10.IndLocalidadVivienda;
                    resu.IndMontoBonificacionAlCliente = res10.IndMontoBonificacionAlCliente;
                    resu.IndMontoExigible = res10.IndMontoExigible;
                    resu.IndMontoPagadoCliente = res10.IndMontoPagadoCliente;
                    resu.IndFolioBuroCredito = res10.IndFolioBuroCredito;
                    resu.IndNumeroAvaluo = res10.IndNumeroAvaluo;
                    resu.IndPorcentajeAsegurado = res10.IndPorcentajeAsegurado;
                    resu.IndValorAvaluo = res10.IndValorAvaluo;
                    resu.IndTasaInteres = res10.IndTasaInteres;
                    resu.IndCodigoCreditoReestructurado = res10.IndCodigoCreditoReestructurado;
                    resu.IndEstado = res10.IndEstado;
                    resu.IndMunicipio = res10.IndMunicipio;
                    resu.IndSaldoPromedio = res10.IndSaldoPromedio;
                    resu.IndInteresCarteraVencida = res10.IndInteresCarteraVencida;
                    resu.IndMontoApoyoBancaDesarrollo = res10.IndMontoApoyoBancaDesarrollo;
                    resu.IndMontoSucbcuenta = res10.IndMontoSucbcuenta;
                    resu.IndMontoOriginal = res10.IndMontoOriginal;
                    resu.IndMontoCofinanciado = res10.IndMontoCofinanciado;
                    resu.IndMontoReestructura = res10.IndMontoReestructura;
                    resu.IndMontoSubsidioFederal = res10.IndMontoSubsidioFederal;
                    resu.IndProductoHipotecario = res10.IndProductoHipotecario;
                    resu.IndSeguroCargoCliente = res10.IndSeguroCargoCliente;
                    resu.IndSituacionCredito = res10.IndSituacionCredito;
                    resu.IndResponsabilidadTotal = res10.IndResponsabilidadTotal;
                    resu.IndSaldoFinalCapital = res10.IndSaldoFinalCapital;
                    resu.IndSaldoInicialCapital = res10.IndSaldoInicialCapital;
                    resu.IndInteresDevengado = res10.IndInteresDevengado;
                    resu.IndTasaComisiones = res10.IndTasaComisiones;
                    resu.IndDestino = res10.IndDestino;
                    resu.IndEntidadSeguro = res10.IndEntidadSeguro;
                    resu.IndEntidadCofinanciadora = res10.IndEntidadCofinanciadora;
                    resu.IndMontoBonificacionPorDeudor = res10.IndMontoBonificacionPorDeudor;
                    resu.IndSectorLaboral = res10.IndSectorLaboral;
                    resu.IndTasaReferencia = res10.IndTasaReferencia;
                    resu.IndTipoAlta = res10.IndTipoAlta;
                    resu.IndTipoBaja = res10.IndTipoBaja;
                    resu.IndTipoComprobacionIngresos = res10.IndTipoComprobacionIngresos;
                    resu.IndTipoSeguro = res10.IndTipoSeguro;
                    resu.IndTipoTasaInteres = res10.IndTipoTasaInteres;
                    resu.IndValorBienAdjudicado = res10.IndValorBienAdjudicado;
                    resu.IndIntExp = res10.IndIntExp;
                    resu.IndAtr = res10.IndAtr;
                    resu.IndMaxAtr = res10.IndMaxAtr;
                    resu.IndPorPago = res10.IndPorPago;
                    resu.IndPorCtlvi = res10.IndPorCtlvi;
                    resu.IndTri = res10.IndTri;
                    resu.IndSubcvi = res10.IndSubcvi;
                    resu.IndSdesi = res10.IndSdesi;
                    resu.IndConvenio = res10.IndConvenio;
                    resu.IndPorCobPaMed = res10.IndPorCobPaMed;
                    resu.IndPorCobPP = res10.IndPorCobPP;
                    resu.IndComision = res10.IndComision;
                    resu.IndTipoCreditoR04A = res10.IndTipoCreditoR04A;
                    resu.IndNumeroAmortizacionVigente = res10.IndNumeroAmortizacionVigente;
                    resu.IndCreditoReestructurado = res10.IndCreditoReestructurado;

                   

                    results.Add(resu);


                }

            }
            catch (Exception ex)
            {
                throw ex;
            }
            return results;
        }
    }
}
