﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class NumeroAgrupacionDataAccess
    {
        #region Consulta

        public List<NumeroAgrupacion> ListadoNumeroAgrupacion()
        {

            List<NumeroAgrupacion> results = new List<NumeroAgrupacion>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatNumeroAgrupacion()
                                select new NumeroAgrupacion()
                                {
                                    iGrupoId = item.iGrupoId,
                                    Grupo_Desc = item.Grupo_Desc
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
