﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class OperacionFormalizadaDataAccess
    {
        #region Consulta

        public List<OperacionFormalizada> ListadoOperacionFormalizada()
        {

            List<OperacionFormalizada> results = new List<OperacionFormalizada>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatOperacionFormalizada()
                                select new OperacionFormalizada()
                                {
                                    tintOperFormaID = item.tintOperFormaID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
