﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class PeriodicidadCapDataAccess
    {
        #region Consulta

        public List<PeriodicidadCap> ListadoPeriodicidadCap()
        {

            List<PeriodicidadCap> results = new List<PeriodicidadCap>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatPeriodicidadCap()
                                select new PeriodicidadCap()
                                {
                                    tintPeriodicidadCap = item.tintPeriodicidadCap,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
