﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class ReestructuraDataAccess
    {
        #region Consulta

        public List<Reestructura> ListadoReestructura()
        {

            List<Reestructura> results = new List<Reestructura>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatReestructura()
                                select new Reestructura()
                                {
                                    tintEstatusRestrucID = item.tintEstatusRestrucID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
        
}
