﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class TasaReferenciaDataAccess
    {
        #region Consulta

        public List<TasaReferencia> ListadoTasaReferencia()
        {

            List<TasaReferencia> results = new List<TasaReferencia>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatTasaReferencia()
                                select new TasaReferencia()
                                {
                                    sintTasaRefID = item.sintTasaRefID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
