﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class TipoAltaDataAccess
    {
        #region Consulta

        public List<TipoAlta> ListadoTipoAlta()
        {

            List<TipoAlta> results = new List<TipoAlta>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatTipoAlta()
                                select new TipoAlta()
                                {
                                    tintTipoAltaID = item.tintTipoAltaID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
