﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HCM.DataAccess.Context;
using HCM.BusinessEntities;

namespace HCM.DataAccess
{
    public class TipoBajaDataAccess
    {
        #region Consulta

        public List<TipoBaja> ListadoTipoBaja()
        {

            List<TipoBaja> results = new List<TipoBaja>();

            try
            {
                using (lnqCatalogosDataContext dc = new lnqCatalogosDataContext(Helper.ConnectionString()))
                {
                    var query = from item in dc.stp_ListarCatTipoBaja()
                                select new TipoBaja()
                                {
                                    tintTipoBajaID = item.tintTipoBajaID,
                                    vchDescripcion = item.vchDescripcion
                                };

                    results.AddRange(query);
                }

            }
            catch (Exception ex)
            {

                throw ex;
            }

            return results;
        }

        #endregion
    }
}
