﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using HCM.DataAccess.Context;
using HCM.BusinessEntities;


namespace HCM.DataAccess
{
    public class clsMenu
    {
        private lnqSeguridadDataContext objetos = new lnqSeguridadDataContext();

        /// <summary>
        /// Método Consulta
        /// </summary>
        /// <param name="intPerfil"></param>
        /// <param name="strRuta"></param>
        /// <returns></returns>
        public List<PermisoObjeto> Consulta(int intPerfil, string strRuta)
        {
            try
            {
                List<PermisoObjeto> lstObj = new List<PermisoObjeto>();

                var lstSp = from a in objetos.stp_getListaObjetosPorPerfil(intPerfil, strRuta)
                            select new PermisoObjeto()
                            {
                                bObjetoVisible = a.bObjetoVisible,
                                shObjetoID = (short)a.sintObjetoID,
                                sintObjetoPadre = a.sintObjetoPadre,
                                sintOrden = a.sintOrden,
                                vchNombreObjeto = a.vchNombreObjeto,
                                vchObjeto = a.vchObjeto
                            };

                lstObj.AddRange(lstSp);


                return lstObj;
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }
        }


        public int ObtieneRolSistema(short shSistemaID, int intUsuarioID)
        {
            try
            {
                var result = objetos.stp_getRolSistema(shSistemaID, intUsuarioID).ToList();
                
                if (result.Count() > 0)
                
                    return result.FirstOrDefault().intRolSistemaID;
                
                else
                    
                    return 0;
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }

        }
    }
}
