﻿using System;
using System.Data;
using System.Configuration;
using System.Globalization;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

/// <summary>
/// Summary description for clsUtilerias
/// </summary>
public class clsUtilerias
{
    // public const
    public int NULL_INTEGER = 0;
    public String NULL_STRING = "";
    public String NULL_DATE = "01/01/1900";
    public String NULL_DATE1 = "00/00/0";

    /*    public String gsMensaje = "";
        public String gsRespEnv = "";
        public String gsIdEnvio = "";
        */

    // Constructor
    public clsUtilerias()
    {
    }

    public static String validaFecha(String fecha, String msg)
    {
        bool error = false;
        fecha = fecha.Trim();
        if (fecha.Equals(""))
        {
            return "OK";
        }

        String[] aFecha = fecha.Split('/');

        if (aFecha.Length != 3)
        {
            error = true;
        }
        else
        {
            int dia;
            int mes;
            int anio;
            bool isNumericDia = int.TryParse(aFecha[0], out dia);
            bool isNumericMes = int.TryParse(aFecha[0], out mes);
            bool isNumericAnio = int.TryParse(aFecha[0], out anio);
            error = !isNumericDia || !isNumericMes || !isNumericAnio;

            if (!error)
            {
                try
                {
                    DateTime dfecha = DateTime.Parse(fecha, new CultureInfo("es-MX", false));
                }
                catch
                {
                    error = true;
                }

                // Ya no tiene caso verificar que el dia sea mayor a 31, o el mes mayor a 12, o el año tenga mas de 4 digitos
            }
        }
        if (error)
        {
            return "La fecha " + msg + " no cumple con el formato establecido (dd/mm/aaaa)";
        }
        else
        {
            return "OK";
        }
    }

    public static String obtieneFechaSQL(String fecha, bool conComillas)
    {
        String esFechaValida = validaFecha(fecha, "fecha");
        if (esFechaValida.Equals("OK"))
        {
            fecha = fecha.Trim();
            String[] afecha = fecha.Split('/');
            if (conComillas)
            {
                return "'" + afecha[2].Trim() + afecha[1].Trim() + afecha[0].Trim() + "'";
            }
            else
            {
                return afecha[2].Trim() + afecha[1].Trim() + afecha[0].Trim();
            }
        }
        else
        {
            return "NULL";
        }
    }
    public static void cargaDropDownList(Object[] carga, string DataTextField, string DataValueField, ref DropDownList drp)
    {
        drp.DataSource = carga;
        drp.DataTextField = DataTextField;
        drp.DataValueField = DataValueField;
        drp.DataBind();
        //if (DataValueField != "ID") //Entidad Federativa
        //{
        drp.Items.Insert(0, "[Seleccionar...]");
        //}
    }


    //Fill TreeNode with object array, sttting text and value properties
    public static TreeNode FillTreeView(Object[] ListObjects, String NodeText, String NodeValue, String FieldText, String FieldValue)
    {
        TreeNode nodeParent = new TreeNode(NodeText, NodeValue);
        nodeParent.Expanded = false;

        foreach (Object obj in ListObjects)
        {
            nodeParent.ChildNodes.Add(new TreeNode(obj.GetType().GetProperty(FieldText).GetValue(obj, null).ToString(), obj.GetType().GetProperty(FieldValue).GetValue(obj, null).ToString()));
        }

        return nodeParent;
    }

    public static void cargaCheckBoxList(Object[] carga, string DataTextField, string DataValueField, ref CheckBoxList drp)
    {
        drp.DataSource = carga;
        drp.DataTextField = DataTextField;
        drp.DataValueField = DataValueField;
        drp.DataBind();

    }

    public static void cargaCheckBoxListUmbral(Object[] carga, string DataTextField, string DataValueField, ref CheckBoxList drp)
    {
        drp.DataSource = carga;
        drp.DataTextField = DataTextField;
        drp.DataValueField = DataValueField;
        drp.DataBind();
        drp.Items.Insert(0, "NACIONAL");

    }

    public static void cargaListBox(Object[] carga, string DataTextField, string DataValueField, ref ListBox drp)
    {
        drp.DataSource = carga;
        drp.DataTextField = DataTextField;
        drp.DataValueField = DataValueField;
        drp.DataBind();

    }
}