﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;

namespace bajaWare.Credito
{
    public partial class frmCredito : System.Web.UI.Page
    {
        int iOperacionId
        {
            get
            {
                return (ViewState["iOperacionId"] == null ? 0 : (int)ViewState["iOperacionId"]);
            }
            set
            {
                ViewState["iOperacionId"] = value;
            }
        }
        public InterfacesServicesCatalogos.IinterfacesServicesCatalogos rsCatalogos = new InterfacesServicesCatalogos.IinterfacesServicesCatalogosClient();
        public CreditoEmpresarialService.ICreditoEmpresarialService rsCreditoEmp = new CreditoEmpresarialService.CreditoEmpresarialServiceClient();


        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                int idOperacion = Convert.ToInt32(Request.QueryString["intCredito"].ToString());

                InterfacesService.CreditosBusqueda busqueda = new InterfacesService.CreditosBusqueda();

                busqueda.intOperacionID = idOperacion;
                busqueda.strNombre = string.Empty;
                busqueda.strDesarrollo = string.Empty;
                busqueda.strTipoNegocio = Session["negocio"].ToString();
                InterfacesService.CreditosResult result = new InterfacesService.IinterfacesServiceClient().ObtieneCreditos(busqueda).ToList().First();
                Label TituloPagina = (Label)this.Master.FindControl("lblNomModulo");
                TituloPagina.Text = result.iOperacionId.ToString() + "- " + result.vhcNombre;
        
                int IdDepartamento = Convert.ToInt32(Session["sintDepartamentoID"]);// 16-Credito Empresarial -17 Credito Individual -20 Finanzas
                bool bitCapturaTodo = Convert.ToBoolean(Convert.ToInt32(Session["bitCapturaTodo"]));

                if (!bitCapturaTodo)
                {
                    if (IdDepartamento == 16)//Credito
                    {
                        tabContabilidad.Visible = false;
                        tabMesaControlAuditoria.Visible = false;
                        tabMesaControlCobranza.Visible = false;
                        tabOperaciones.Visible = false;
                        tabPromocion.Visible = false;
                        tabTesoreria.Visible = false;
                        TabFinanzas.Visible = false;
                        Tabs.ActiveTabIndex = 0;
                    }
                    else if (IdDepartamento == 26)//Operacion
                    {
                        tabContabilidad.Visible = false;
                        tabMesaControlAuditoria.Visible = false;
                        tabMesaControlCobranza.Visible = false;
                        tabCredito.Visible = false;
                        tabPromocion.Visible = false;
                        tabTesoreria.Visible = false;
                        TabFinanzas.Visible = false;
                        Tabs.ActiveTabIndex = 1;
                    }
                    else if (IdDepartamento == 13)//Contabilidad
                    {
                        tabMesaControlAuditoria.Visible = false;
                        tabOperaciones.Visible = false;
                        tabMesaControlCobranza.Visible = false;
                        tabCredito.Visible = false;
                        tabPromocion.Visible = false;
                        tabTesoreria.Visible = false;
                        TabFinanzas.Visible = false;
                        Tabs.ActiveTabIndex = 2;
                    }
                    else if (IdDepartamento == 25)//Mesa Control/Auditoria
                    {
                        tabContabilidad.Visible = false;
                        tabOperaciones.Visible = false;
                        //tabMesaControlCobranza.Visible = false;
                        tabCredito.Visible = false;
                        tabPromocion.Visible = false;
                        tabTesoreria.Visible = false;
                        TabFinanzas.Visible = false;
                        Tabs.ActiveTabIndex = 3;
                    }
                    else if (IdDepartamento == 25 || IdDepartamento == 9)//Mesa Control / Cobranza
                    {
                        tabContabilidad.Visible = false;
                        tabOperaciones.Visible = false;
                        if (IdDepartamento == 9)
                            tabMesaControlAuditoria.Visible = false;
                        tabCredito.Visible = false;
                        tabPromocion.Visible = false;
                        tabTesoreria.Visible = false;
                        TabFinanzas.Visible = false;
                        Tabs.ActiveTabIndex = 4;
                    }

                    else if (IdDepartamento == 36)//Tesoreria
                    {
                        tabContabilidad.Visible = false;
                        tabOperaciones.Visible = false;
                        tabMesaControlAuditoria.Visible = false;
                        tabCredito.Visible = false;
                        tabMesaControlCobranza.Visible = false;
                        tabPromocion.Visible = false;
                        TabFinanzas.Visible = false;
                        Tabs.ActiveTabIndex = 5;
                    }
                    else if (IdDepartamento == 28)//Promocion
                    {
                        tabContabilidad.Visible = false;
                        tabOperaciones.Visible = false;
                        tabMesaControlAuditoria.Visible = false;
                        tabCredito.Visible = false;
                        tabMesaControlCobranza.Visible = false;
                        tabTesoreria.Visible = false;
                        TabFinanzas.Visible = false;
                        Tabs.ActiveTabIndex = 6;
                    }
                    else if (IdDepartamento == 20)//Finanzas
                    {
                        tabContabilidad.Visible = false;
                        tabOperaciones.Visible = false;
                        tabMesaControlAuditoria.Visible = false;
                        tabCredito.Visible = false;
                        tabMesaControlCobranza.Visible = false;
                        tabTesoreria.Visible = false;
                        tabPromocion.Visible = false;
                        TabFinanzas.Visible = true;
                        Tabs.ActiveTabIndex = 7;
                    }
                }

                iOperacionId = Convert.ToInt32(Request.QueryString["intCredito"].ToString());
                ddlTipoBaja.DataSource = rsCatalogos.ListaTipoBaja();
                ddlTipoBaja.DataValueField = "intInterfaceid";
                ddlTipoBaja.DataTextField = "vchInterface";
                ddlTipoBaja.DataBind();
                ddlPeriodicidadCapital.DataSource = rsCatalogos.ListaPeriodicidadCap();
                ddlPeriodicidadCapital.DataValueField = "intInterfaceid";
                ddlPeriodicidadCapital.DataTextField = "vchInterface";
                ddlPeriodicidadCapital.DataBind();
                ddlOperacionFormalizada.DataSource = rsCatalogos.ListaOperacionFormalizada();
                ddlOperacionFormalizada.DataValueField = "intInterfaceid";
                ddlOperacionFormalizada.DataTextField = "vchInterface";
                ddlOperacionFormalizada.DataBind();
                ddlExpedienteCompleto.DataSource = rsCatalogos.ListaExpedienteCompleto();
                ddlExpedienteCompleto.DataValueField = "intInterfaceid";
                ddlExpedienteCompleto.DataTextField = "vchInterface";
                ddlExpedienteCompleto.DataBind();
                ddlInformacionRecuperacion.DataSource = rsCatalogos.ListaInformacionRecuperacion();
                ddlInformacionRecuperacion.DataValueField = "intInterfaceid";
                ddlInformacionRecuperacion.DataTextField = "vchInterface";
                ddlInformacionRecuperacion.DataBind();
                ddlInstitutoFondea.DataSource = rsCatalogos.ListaInstitucion();
                ddlInstitutoFondea.DataValueField = "intInterfaceid";
                ddlInstitutoFondea.DataTextField = "vchInterface";
                ddlInstitutoFondea.DataBind();
                ddlClasificacionContable.DataSource = rsCatalogos.ListarClasificacionContable();
                ddlClasificacionContable.DataValueField = "intInterfaceid";
                ddlClasificacionContable.DataTextField = "vchInterface";
                ddlClasificacionContable.DataBind();
                ddlTipoCredito.DataSource = rsCatalogos.ListarTipoCreditoPromo();
                ddlTipoCredito.DataValueField = "intInterfaceid";
                ddlTipoCredito.DataTextField = "vchInterface";
                ddlTipoCredito.DataBind();
                ScriptManager.RegisterStartupScript(this, this.GetType(), "cambia", "CambiaTabs();", true);
                LlenaDatos();
            }
        }

        private void LlenaDatos()
        {
            CreditoEmpresarialService.CreditoEmpresarial creditoEmpresarial = new CreditoEmpresarialService.CreditoEmpresarial();

            creditoEmpresarial = rsCreditoEmp.ListarCreditoEmpresarial(iOperacionId).First();

            ddlTipoBaja.SelectedValue = creditoEmpresarial.tintTipoBajaID.ToString();
            if (creditoEmpresarial.tintPeriodicidadCap != null)
                ddlPeriodicidadCapital.SelectedValue = creditoEmpresarial.tintPeriodicidadCap.ToString();
           if(creditoEmpresarial.tintOperFormaID!=null)
                ddlOperacionFormalizada.SelectedValue = creditoEmpresarial.tintOperFormaID.ToString();
            if(creditoEmpresarial.tintExpedienCompID!=null)
            ddlExpedienteCompleto.SelectedValue = creditoEmpresarial.tintExpedienCompID.ToString();
            if (creditoEmpresarial.tintInfoRecuperaID != null)
             ddlInformacionRecuperacion.SelectedValue = creditoEmpresarial.tintInfoRecuperaID.ToString();
            ddlInstitutoFondea.SelectedValue = creditoEmpresarial.iInstitutoFondea.ToString();
            if (creditoEmpresarial.sintClasificacionContaID != null)
                ddlClasificacionContable.SelectedValue = creditoEmpresarial.sintClasificacionContaID.ToString();
            if (creditoEmpresarial.sintTipoCreditoIDPromo != null)
                ddlTipoCredito.SelectedValue = creditoEmpresarial.sintTipoCreditoIDPromo.ToString();
            if (creditoEmpresarial.decPorGarantiaFon > 0)
                txtPorcentajeGarFond.Text = creditoEmpresarial.decPorGarantiaFon == 100 ? "100" : Convert.ToDecimal(creditoEmpresarial.decPorGarantiaFon).ToString();
            wucCredEmpresCredito1.LlenaDatos(creditoEmpresarial);
            
        }

        protected void btnGuardar_Click(object sender, EventArgs e)
        {
            CreditoEmpresarialService.CreditoEmpresarial creditoEmpresarial = new CreditoEmpresarialService.CreditoEmpresarial();
            int IoperacionId = Convert.ToInt32(Request.QueryString["intCredito"].ToString());
            creditoEmpresarial.iOperacionId = IoperacionId;
            switch (Tabs.ActiveTabIndex + 1)
            {
                case 1:
                   
                    creditoEmpresarial.iOpcion = 1;
                    if (wucCredEmpresCredito1.Inserta(creditoEmpresarial))
                    {
                        ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "Inserta", "alert('Se actualizo el registro con exito')", true);

                    }
                    else
                    {
                        ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "error", "alert('Ocurrio un error al insertar el registro')", true);
                    }
                    break;
                case 2:
                    creditoEmpresarial.iOpcion = 2;
                    creditoEmpresarial.tintTipoBajaID = Convert.ToInt16(ddlTipoBaja.SelectedValue);
                    if (ddlPeriodicidadCapital.SelectedValue == "-1")
                        creditoEmpresarial.tintPeriodicidadCap = null;
                    else
                        creditoEmpresarial.tintPeriodicidadCap = Convert.ToInt16(ddlPeriodicidadCapital.SelectedValue);
                    break;
                case 3:
                    if (ddlClasificacionContable.SelectedValue == "-1")
                        creditoEmpresarial.sintClasificacionContaID = null;
                    else
                    creditoEmpresarial.sintClasificacionContaID = Convert.ToInt16(ddlClasificacionContable.SelectedValue);
                    creditoEmpresarial.iOpcion =3;
                    break;
                case 4:
                    creditoEmpresarial.iOpcion = 4;
                    if (ddlOperacionFormalizada.SelectedValue == "-1")
                        creditoEmpresarial.tintOperFormaID = null;
                    else
                        creditoEmpresarial.tintOperFormaID = Convert.ToInt16(ddlOperacionFormalizada.SelectedValue);
                    if (ddlExpedienteCompleto.SelectedValue == "-1")
                        creditoEmpresarial.tintExpedienCompID = null;
                    else
                        creditoEmpresarial.tintExpedienCompID = Convert.ToInt16(ddlExpedienteCompleto.SelectedValue);
                    break;
                case 5:
                    creditoEmpresarial.iOpcion = 5;
                    if (ddlInformacionRecuperacion.SelectedValue == "-1")
                        creditoEmpresarial.tintInfoRecuperaID = null;
                    creditoEmpresarial.tintInfoRecuperaID = Convert.ToInt16(ddlInformacionRecuperacion.SelectedValue);
                    break;
                case 6:
                    creditoEmpresarial.iOpcion = 6;
                    creditoEmpresarial.iInstitutoFondea = Convert.ToInt16(ddlInstitutoFondea.SelectedValue);
                    break;
                case 7:
                    creditoEmpresarial.iOpcion = 7;
                    if (ddlTipoCredito.SelectedValue == "0")
                        creditoEmpresarial.sintTipoCreditoIDPromo = null;
                    else
                        creditoEmpresarial.sintTipoCreditoIDPromo = Convert.ToInt16(ddlTipoCredito.SelectedValue);
                    break;
                case 8:
                    creditoEmpresarial.iOpcion = 8;
                    if (txtPorcentajeGarFond.Text != string.Empty)
                        creditoEmpresarial.decPorGarantiaFon = Convert.ToDecimal(txtPorcentajeGarFond.Text);
                    break;

            }
            if (Tabs.ActiveTabIndex != 0)
            {
                rsCreditoEmp.ActualizaCreditoEmpresarial(creditoEmpresarial);
                ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "Inserta", "alert('Se actualizo el registro con exito')", true);
            }
        }

        protected void btnAtras_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Interfaces/frmBusqueda.aspx?operacion='c''");
        }
    }
}