﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;

namespace bajaWare.Credito
{
    public partial class frmCreditoHipotecario : System.Web.UI.Page
    {
        public int? iPersonaId
        {
            get
            {
                return (int)ViewState["iPersonaId"];
            }
            set
            {
                ViewState["iPersonaId"] = value;
            }
        }

        public InterfacesServicesCatalogos.IinterfacesServicesCatalogos rsCatalogos = new InterfacesServicesCatalogos.IinterfacesServicesCatalogosClient();
        public InterfaceServiceCreditHipot.IinterfacesServiceCreditHipot rsCreditHipo = new InterfaceServiceCreditHipot.IinterfacesServiceCreditHipotClient();
        protected void Page_Load(object sender, EventArgs e)
        {
            bool bitCapturaTodo = Convert.ToBoolean(Convert.ToInt32(Session["bitCapturaTodo"]));
            int IdDepartamento = Convert.ToInt32(Session["sintDepartamentoID"]);// 16-Credito Empresarial -17 Credito Individual -25 Mesa Control
            if (!IsPostBack)
            {

      // --Credito       17
      //--Operaciones   26
      //--Mesa Control  25

               // btnGuardar.ValidationGroup = "Credito";
                 

                 if (!bitCapturaTodo)
                 {

                     if (IdDepartamento == 17)//Credito
                     {
                         tabOperaciones.Visible = false;
                         tabMesaControl.Visible = false;
                         Tabs.ActiveTabIndex = 0;
                         ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "activa", "CambiaTab('0');", true);
                     }
                     if (IdDepartamento == 26)//Operacion
                     {
                         tabCredito.Visible = false;
                         tabMesaControl.Visible = false;
                         Tabs.ActiveTabIndex = 1;
                         ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "activa", "CambiaTab('1');", true);
                     }
                     if (IdDepartamento == 25)//Mesa Control
                     {
                         tabOperaciones.Visible = false;
                         tabCredito.Visible = false;
                         Tabs.ActiveTabIndex = 2;
                         ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "activa", "CambiaTab('2');", true);
                     }
                 }
                LlenaCombos();
                int idOperacion = Convert.ToInt32(Request.QueryString["intCredito"].ToString());

                InterfacesService.CreditosBusqueda busqueda = new InterfacesService.CreditosBusqueda();

                busqueda.intOperacionID = idOperacion;
                busqueda.strNombre = string.Empty;
                busqueda.strDesarrollo = string.Empty;
                busqueda.strTipoNegocio = Session["negocio"].ToString();

                InterfacesService.CreditosResult result=new InterfacesService.IinterfacesServiceClient().ObtieneCreditos(busqueda).ToList().First();
                Label TituloPagina = (Label)this.Master.FindControl("lblNomModulo");
                TituloPagina.Text = result.iOperacionId.ToString()+"- "+result.vhcNombre;
                CargaValores(idOperacion);
                
            }
            // 16-Credito Empresarial -17 Credito Individual -25 Mesa Control
               
             

             if (!bitCapturaTodo)
             {
                 if (IdDepartamento == 17)//Credito
                 {

                     ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "activa", "CambiaTab('0');", true);
                 }
                 if (IdDepartamento == 26)//Operacion
                 {

                     ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "activa", "CambiaTab('1');", true);
                 }
                 if (IdDepartamento == 25)//Mesa Control
                 {

                     ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "activa", "CambiaTab('2');", true);
                 }
             }
             ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "activa", "CambiaTab('0');", true);
        }

        private void CargaValores(int idOperacion)
        {
            InterfaceServiceCreditHipot.CreditoHipotecario creditHipo= new InterfaceServiceCreditHipot.CreditoHipotecario();
            creditHipo.iOperacionId = idOperacion;

            List<InterfaceServiceCreditHipot.CreditoHipotecario> lsCredito=rsCreditHipo.ListarCreditHipotecario(creditHipo).ToList();
            if (lsCredito.Count > 0)
            {
                InterfaceServiceCreditHipot.CreditoHipotecario cHipotec = lsCredito.First();
                //txtPorcentajeAsegurado.Text = cHipotec.dpConcedido.ToString().Replace(',','.');
                ddlEntidadSeguro.SelectedValue = cHipotec.sintEntAsegID.ToString();
                chkSeguroCargoCliente.Checked = (bool)cHipotec.bitSeguroCargoCli;
                chkConvenio.Checked = (bool)cHipotec.BitConvenio;
                iPersonaId = cHipotec.iPersonaId;
                wucCredHipotecsCredito1.CargaInformacion(cHipotec);
            }
            else
            {
                ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "Mensaje", "alert('No existen Datos de Credito'", true);
            }
            //chkConvenio.Checked = (bool)cHipotec.;

        }

        private void LlenaCombos()
        {
          
            ddlEntidadSeguro.DataSource = rsCatalogos.ListarEntidadSeguro();
            ddlEntidadSeguro.DataTextField = "vchInterface";
            ddlEntidadSeguro.DataValueField = "intInterfaceid";
            ddlEntidadSeguro.DataBind();

        }

        protected void btnGuardar_Click(object sender, EventArgs e)
        {
            InterfaceServiceCreditHipot.CreditoHipotecario cHipotec  = new InterfaceServiceCreditHipot.CreditoHipotecario();
            int IoperacionId = Convert.ToInt32(Request.QueryString["intCredito"].ToString()); ;
            cHipotec.iOperacionId = IoperacionId;
            cHipotec.iPersonaId = iPersonaId;
            switch (Tabs.ActiveTabIndex + 1)
            {
                case 1:
                    if ((bool)(wucCredHipotecsCredito1.CPvalido == null ? true : wucCredHipotecsCredito1.CPvalido))
                    {
                        cHipotec.iOpcion = 1;
                        wucCredHipotecsCredito1.Inserta(cHipotec);
                        ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "exito", "alert('Se actualizo el registro exitosamente')", true);
                    }
                    else
                    {
                        ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "ValidaCP", "alert('El codigo postal no es valido')", true);
                    }
                    break;
                case 2:
                    //creditoEmpresarial.iClasificacionContable
                    cHipotec.iOpcion = 2;
                    cHipotec.bitSeguroCargoCli = chkSeguroCargoCliente.Checked;
                    cHipotec.sintEntAsegID = Convert.ToInt16(ddlEntidadSeguro.SelectedValue);
                  //  cHipotec.dpConcedido = Convert.ToDecimal(txtPorcentajeAsegurado.Text.Replace('.',','));
                    rsCreditHipo.ActualizaCreditoHipotecario(cHipotec);
                    ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "exito", "alert('Se actualizo el registro exitosamente')", true);
                    break;
                case 3:
                    cHipotec.iOpcion = 3;
                    cHipotec.BitConvenio = chkConvenio.Checked;
                    rsCreditHipo.ActualizaCreditoHipotecario(cHipotec);
                    ScriptManager.RegisterStartupScript(upd_general, upd_general.GetType(), "exito", "alert('Se actualizo el registro exitosamente')", true);
                    //creditoEmpresarial.tintPeriodicidadCap = Convert.ToInt16(ddlPeriodicidadCapital.SelectedValue);
                    break;
               

            }
            //rsCreditHipo.ActualizaCreditoHipotecario();
        }

        protected void btnAtras_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Interfaces/frmBusqueda.aspx?operacion='c''");
        }
    }
}