﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;


namespace bajaWare.Garantias
{
    public partial class frmGrantias : System.Web.UI.Page
    {
        public InterfacesServicesCatalogos.IinterfacesServicesCatalogos rsCatalogos = new InterfacesServicesCatalogos.IinterfacesServicesCatalogosClient();
        public InterfaceServiceGarantias.IinterfacesServiceGarantia rsGarantias = new InterfaceServiceGarantias.IinterfacesServiceGarantiaClient();
        int UsuarioLog
        {
            get
            {
                return ((int)ViewState["UsuarioLog"]);
            }
            set
            {
                ViewState["UsuarioLog"] = value;
            }
        }
        int? iGarantiasId
        {
            get
            {
                return (ViewState["iGarantiasId"] == null ? 0 : (int)ViewState["iGarantiasId"]);
            }
            set
            {
                ViewState["iGarantiasId"] = value;
            }
        }
        int? iOperacionId
        {
            get
            {
                return (ViewState["iOperacionId"] == null ? 0 : (int)ViewState["iOperacionId"]);
            }
            set
            {
                ViewState["iOperacionId"] = value;
            }
        }
        Int16? individual
        {
            get
            {
                return ((Int16)(ViewState["individual"] == null ? 0 : ViewState["individual"]));
            }
            set
            {
                ViewState["individual"] = value;
            }
        }
        public List<InterfaceServiceGarantias.Garantia> ListaGarantias
        {
            get
            {
                return ViewState["ListaGarantias"] == null ? (new List<InterfaceServiceGarantias.Garantia>()) : (List<InterfaceServiceGarantias.Garantia>)ViewState["ListaGarantias"];
            }
            set
            {
                ViewState["ListaGarantias"] = value;
            }
        }
        protected void Page_Load(object sender, EventArgs e)
        {


            if (!IsPostBack)
            {


                int IdDepartamento=Convert.ToInt32(Session["sintDepartamentoID"]);// 16-Credito Empresarial -17 Credito Individual -20 Finanzas

                bool bitCapturaTodo = Convert.ToBoolean(Convert.ToInt32(Session["bitCapturaTodo"]));
                if (!bitCapturaTodo)
                {
                    if (IdDepartamento == 16 || IdDepartamento == 17)//Credito
                    {
                        tabFinanzas.Visible = false;
                        Tabs.ActiveTabIndex = 0;
                    }
                    else if (IdDepartamento == 20)//Finanzas
                    {
                        tabCredito.Visible = false;
                        Tabs.ActiveTabIndex = 1;
                    }
                }
                else
                {
                    Tabs.ActiveTabIndex = 0;
                }

                UsuarioLog = Convert.ToInt32(Session["UserId"]);
                iGarantiasId = 0;
                iOperacionId = Convert.ToInt32(Request.QueryString["intCredito"].ToString());
                individual = (short)(Session["negocio"].ToString()=="I"?1:0);
                InterfacesService.CreditosBusqueda busqueda = new InterfacesService.CreditosBusqueda();
                busqueda.intOperacionID = Convert.ToInt32(iOperacionId);
                busqueda.strNombre = string.Empty;
                busqueda.strDesarrollo = string.Empty;
                busqueda.strTipoNegocio = Session["negocio"].ToString();

                InterfacesService.CreditosResult result = new InterfacesService.IinterfacesServiceClient().ObtieneCreditos(busqueda).ToList().First();
                Label TituloPagina = (Label)this.Master.FindControl("lblNomModulo");
                TituloPagina.Text = result.iOperacionId.ToString() + "- " + result.vhcNombre;
                
                //iGarantiasId=wucGarantiaCredito1.iGarantiasId;
                ListaGarantias = rsGarantias.ObtieneGarantias(iOperacionId, (int)individual).ToList();
                grvGarantias.DataSource = ListaGarantias;
                grvGarantias.DataBind();
               // this.btnGuardar.Attributes.Add("onclick", "javascript:confirm('Esta seguro de almacenar los datos');");
            }
            
        }      
        private void Inserta()
        {
            wucGarantiaCredito1.iGarantiasId = iGarantiasId;
            wucGarantiaCredito1.iOperacionId = iOperacionId;
            wucGarantiaCredito1.iIndividual = individual;
            InterfaceServiceGarantias.Garantia garantia;
            if(iGarantiasId!=0)
                garantia = ListaGarantias.Find(s => s.iGarantiaId == iGarantiasId);
            else
                garantia = new InterfaceServiceGarantias.Garantia();
            garantia.iGarantiaId = iGarantiasId;
            if (wucGarantiaCredito1.InsertaInformacion(garantia))
            {

                // lblMensaje.ForeColor = System.Drawing.Color.Green;
                ScriptManager.RegisterStartupScript(UPD_Persona, UPD_Persona.GetType(), "Inserta", "alert('Se actualizo el registro con exito')", true);
                ListaGarantias = rsGarantias.ObtieneGarantias(iOperacionId,(int)individual).ToList();
                grvGarantias.DataSource = ListaGarantias;
                grvGarantias.DataBind();
                mdlDatosGarantia.Hide();
                if (iGarantiasId != 0)
                {
                    //ScriptManager.RegisterStartupScript(UPD_MotBusPersonas,UPD_MotBusPersonas.GetType(),"Inserta","alert('Se actualizo el registro con exito')",true);
                }
                else
                {
                    // ScriptManager.RegisterStartupScript(UPD_MotBusPersonas, UPD_MotBusPersonas.GetType(), "Inserta", "alert('Se Inserto el registro con exito')", true);
                }

                iGarantiasId = 0;

            }
            else
            {
                ScriptManager.RegisterStartupScript(UPD_Persona, UPD_Persona.GetType(), "Inserta", "alert('Ocurrio un error comuniquese con el Admin')", true);
                //lblMensaje.ForeColor = System.Drawing.Color.Red;
                //lblMensaje.Text = "Ocurrio un error en la actualizacion, pongase en contacto con el Administrador.";
            }
        }
        protected void btnGuardar_Click1(object sender, EventArgs e)
        {

            if (Tabs.ActiveTabIndex == 0)
            {
                Inserta();
            }
            else
            {

            }
        }
        protected void btnAtras_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Interfaces/frmBusqueda.aspx?operacion='c''");
        }
        protected void btnGo_Click(object sender, ImageClickEventArgs e)
        {
            mdlDatosGarantia.Show();
            iGarantiasId = Convert.ToInt32(((System.Web.UI.WebControls.ImageButton)(sender)).CommandArgument);

            //if (TipoParticipe == 4)
            //{

            //    wucAccionista1.ListaParticipes = ListaParticipes;
            InterfaceServiceGarantias.Garantia garantia = ListaGarantias.Find(s => s.iGarantiaId == iGarantiasId);
            wucGarantiaCredito1.llenaInformacion(garantia);
            //    wucAccionista1.LlenaFormula(Convert.ToInt32(Request.QueryString["intCredito"].ToString()), Convert.ToInt32(((System.Web.UI.WebControls.ImageButton)(sender)).CommandArgument));
            //    mpeAccionista.Show();
            //    UPD_Datosaccionista.Update();
            //}
            //else if (TipoParticipe == 2)
            //{
            //    wucAvalCredito1.LLenaDatos(Convert.ToInt32(((System.Web.UI.WebControls.ImageButton)(sender)).CommandArgument));
            //    mdlDatosDomicilio.Show();
                UPD_DatosDomicilio.Update();
            //}
        }
        protected void grvGarantias_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {

            grvGarantias.PageIndex = e.NewPageIndex;
           // grvGarantias.DataSource = ListaParticipes;
            grvGarantias.DataBind();

        }

        protected void btnGuardaGarantia_Click(object sender, EventArgs e)
        {
            if (Tabs.ActiveTabIndex == 0)
            {
                Inserta();
            }
            else
            {

            }
        }

        protected void btnGuardaAval_Click(object sender, EventArgs e)
        {

        }

        protected void btnAgrega_Click(object sender, EventArgs e)
        {
            iGarantiasId = 0;
            wucGarantiaCredito1.LimpiaDatos();
            mdlDatosGarantia.Show();
        }

       
    }
}