﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace bajaWare.UserControl.Accionista
{
    public partial class wucAccionista : System.Web.UI.UserControl
    {
        public List<InterfacesServicePersonas.Participe> ListaParticipes
        {
            get
            {
                return ViewState["ListaParticipes"] == null ? (new List<InterfacesServicePersonas.Participe>()) : (List<InterfacesServicePersonas.Participe>)ViewState["ListaParticipes"];
            }
            set
            {
                ViewState["ListaParticipes"] = value;
            }
        }

        public InterfacesServicesCatalogos.IinterfacesServicesCatalogos rsCatalogos = new InterfacesServicesCatalogos.IinterfacesServicesCatalogosClient();
        public InterfaceServicesAccionistas.IinterfacesServiceAccionista rsAccionista = new InterfaceServicesAccionistas.IinterfacesServiceAccionistaClient();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                ddlRegimenFiscal.DataSource = rsCatalogos.ListadoRegimenFiscal();
                ddlRegimenFiscal.DataValueField = "intInterfaceid";
                ddlRegimenFiscal.DataTextField = "vchInterface";
                ddlRegimenFiscal.DataBind();
               
               // System.Threading.Thread.CurrentThread.CurrentCulture.NumberFormat.CurrencyDecimalSeparator;
            }
        }
        public bool InsertaActualiza(InterfaceServicesAccionistas.Accionista  accionista)
        {
            bool result = true;
            if (ListaParticipes.FindAll(s=> s.iParticipeId!=accionista.iPersonaId).Sum(s=> s.pParticipacion)+Convert.ToDecimal(txtPorcentaje.Text) <=100)
            {
                accionista.sPrimerNombre = txtNombre.Text.Split(' ')[0];
                string segundoNombre = string.Empty;
                for (int i = 1; txtNombre.Text.Split(' ').Length > i; i++)
                {
                    if (segundoNombre == string.Empty)
                        segundoNombre += txtNombre.Text.Split(' ')[i];
                    else
                        segundoNombre += " " + txtNombre.Text.Split(' ')[i];

                }
                accionista.sSegundoNombre = segundoNombre;
                if (ddlRegimenFiscal.SelectedValue == "1")
                {
                    accionista.sApellidoPaterno = txtApePaterno.Text;
                    accionista.sApellidoMaterno = txtApeMaterno.Text;
                }
                else
                {
                    accionista.sApellidoPaterno = string.Empty;
                    accionista.sApellidoMaterno = string.Empty;
                }
                accionista.iCveRegimenFiscal = Convert.ToInt32(ddlRegimenFiscal.SelectedValue);
                accionista.pParticipacion =decimal.Parse(string.Format(txtPorcentaje.Text));
                
                rsAccionista.InsertaActualizaAccionista(accionista);
                result = true;
            }
            else
            {
                result = false;
                ScriptManager.RegisterStartupScript(UPD_ACCION, UPD_ACCION.GetType(), "ErrorPorc", "alert('No se puede guardar porque el porcentaje excede')", true);
               
            }
 
            return result;
        }
        public void LlenaFormula( int IdOperacion, int Consec)
        {
            InterfaceServicesAccionistas.Accionista accionista = new InterfaceServicesAccionistas.Accionista();
            accionista.Consec=Consec;
            accionista.iOperacionId=IdOperacion;
            accionista= rsAccionista.ObtieneAccionistas(accionista).First();
            txtNombre.Text = accionista.sPrimerNombre + (accionista.sSegundoNombre == string.Empty ? string.Empty : " " + accionista.sSegundoNombre);
            txtApeMaterno.Text = accionista.sApellidoMaterno;
            txtApePaterno.Text = accionista.sApellidoPaterno;
            ddlRegimenFiscal.SelectedValue = accionista.iCveRegimenFiscal.ToString();
            txtPorcentaje.Text = accionista.pParticipacion.ToString().Replace(',','.');
            MuestraOculta();


        }

        protected void ddlRegimenFiscal_SelectedIndexChanged(object sender, EventArgs e)
        {
            MuestraOculta();
        }

        private void MuestraOculta()
        {
            if (ddlRegimenFiscal.SelectedValue == "2")
            {
                txtApePaterno.Visible = false;
                txtApeMaterno.Visible = false;
                tdApePaterno.Visible = false;
                tdApeMaterno.Visible = false;
                rfv_txtApePaterno.Enabled = false;
                rfv_txtApeMaterno.Enabled = false;
                fte_txtNombre.Enabled = false;
               // txtRFC.ValidationExpression = @"^(([A-Z]|[a-z]|\s){1})(([A-Z]|[a-z]){2})([0-9]{6})((([A-Z]|[a-z]|[0-9]){3}))";
            }
            else
            {
                txtApePaterno.Visible = true;
                txtApeMaterno.Visible = true;
                tdApePaterno.Visible = true;
                tdApeMaterno.Visible = true;
                rfv_txtApePaterno.Enabled = true;
                rfv_txtApeMaterno.Enabled = true;
                fte_txtNombre.Enabled = true;
               // rev_txtRFC.ValidationExpression = @"^(([A-Z]|[a-z]|\s){1})(([A-Z]|[a-z]){3})([0-9]{6})((([A-Z]|[a-z]|[0-9]){3}))";
            }
        }

    }
}