﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace bajaWare.UserControl.Cliente
{
    public partial class wucPersonaCredito : System.Web.UI.UserControl
    {


        public delegate void getRegistroEventHandler(string mensaje, Int16 sintTipo);
        public event getRegistroEventHandler getRegistroEventMsjCerd;


        public InterfacesServicesCatalogos.IinterfacesServicesCatalogos rsCatalogos = new InterfacesServicesCatalogos.IinterfacesServicesCatalogosClient();


        protected void Page_Load(object sender, EventArgs e)
        {

        }

        public void HabilitaControles(bool isIndividual)
        {

            ddlTamanioDeudor.Enabled = !isIndividual;
            ddlRiesgoIndustria.Enabled = !isIndividual;
            ddlRiesgoFinanciero.Enabled = !isIndividual;

            if (isIndividual)
            {
                ddlRiesgoFinanciero.BackColor = System.Drawing.Color.Orange;
                ddlRiesgoIndustria.BackColor = System.Drawing.Color.Orange;
                ddlTamanioDeudor.BackColor = System.Drawing.Color.Orange;
                rfv_ddlTamanioDeudor.ValidationGroup = "";
                rfv_ddlRiesgoIndustria.ValidationGroup = "";
                rfv_ddlRiesgoFinanciero.ValidationGroup = "";
            }

        }

        public void HabilitaControlesPF(bool isFisica)
        {
            ddlExperienciaPago.Enabled = !isFisica;
            txtNombreCNBVCred.Enabled = !isFisica;
            if (isFisica)
            {
                ddlExperienciaPago.BackColor = System.Drawing.Color.Orange;
                rfv_ddlExperienciaPago.ValidationGroup = "";
                rfv_txtNombreCNBVCred.ValidationGroup = "";
            }
        }

        public void InsertaDatosPersona(InterfacesServicePersonas.clsDatosPersona clsPersona)
        {

            try
            {
                ViewState["intPersonaID"] = clsPersona.intPersonaID;

                ddlExperienciaPago.SelectedValue = clsPersona.shExperienciaPagoID.ToString();
                txtFolioConsultaBuro.Text = clsPersona.strFolioConsultaBuro;
                txtFechaConsultaBuro.Text = clsPersona.strFechaConsultaBuro == "01/01/1900" ? "" : clsPersona.strFechaConsultaBuro;
                txtIngresosBrutos.Text = clsPersona.decIngresosBrutos.ToString() == "0" ? "0.00" : clsPersona.decIngresosBrutos.ToString("#,#.##");
                txtNombreCNBVCred.Text = clsPersona.strNombreCNBV;

                CargaCatalogos();

                ddlTamanioDeudor.SelectedValue = clsPersona.shTamanoDeudorID.ToString();
                ddlComprobanteIngresos.SelectedValue = clsPersona.shComprobanteIngresos.ToString();
                ddlRelacionAcreditado.SelectedValue = clsPersona.shRelacionAcreditado.ToString();
                ddlSectorLaboral.SelectedValue = clsPersona.shSectorLaboral.ToString();
                ddlTipoAcreditadoRelacionado.SelectedValue = clsPersona.shTipoAcreditadoRelacionadoID.ToString();
                ddlRiesgoIndustria.SelectedValue = clsPersona.shRiesgoIndustriaID.ToString();
                ddlRiesgoFinanciero.SelectedValue = clsPersona.shRiesgoFinancieroID.ToString();
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }

        }



        public void CargaCatalogos()
        {
            try
            {
                ddlRelacionAcreditado.DataSource = rsCatalogos.ListadoRelacionAcreditado();
                ddlRelacionAcreditado.DataTextField = "vchInterface";
                ddlRelacionAcreditado.DataValueField = "intInterfaceid";
                ddlRelacionAcreditado.DataBind();


                ddlSectorLaboral.DataSource = rsCatalogos.ListadoSectorLaboral();
                ddlSectorLaboral.DataTextField = "vchInterface";
                ddlSectorLaboral.DataValueField = "intInterfaceid";
                ddlSectorLaboral.DataBind();

                if (Session["negocio"].ToString() == "I")
                    ddlComprobanteIngresos.DataSource = rsCatalogos.ListadoComprobanteIngresosInividual();
                else
                    ddlComprobanteIngresos.DataSource = rsCatalogos.ListadoComprobanteIngresos();

                ddlComprobanteIngresos.DataTextField = "vchInterface";
                ddlComprobanteIngresos.DataValueField = "intInterfaceid";
                ddlComprobanteIngresos.DataBind();

                ddlTipoAcreditadoRelacionado.DataSource = rsCatalogos.ListadoTipoDeudorRelacionado();
                ddlTipoAcreditadoRelacionado.DataTextField = "vchInterface";
                ddlTipoAcreditadoRelacionado.DataValueField = "intInterfaceid";
                ddlTipoAcreditadoRelacionado.DataBind();

                ddlTamanioDeudor.DataSource = rsCatalogos.ListadoTamDeudor();
                ddlTamanioDeudor.DataTextField = "vchInterface";
                ddlTamanioDeudor.DataValueField = "intInterfaceid";
                ddlTamanioDeudor.DataBind();

                ddlRiesgoFinanciero.DataSource = rsCatalogos.ListadoGradoRiesgo();
                ddlRiesgoFinanciero.DataTextField = "vchInterface";
                ddlRiesgoFinanciero.DataValueField = "intInterfaceid";
                ddlRiesgoFinanciero.DataBind();

                ddlRiesgoIndustria.DataSource = rsCatalogos.ListadoGradoRiesgo();
                ddlRiesgoIndustria.DataTextField = "vchInterface";
                ddlRiesgoIndustria.DataValueField = "intInterfaceid";
                ddlRiesgoIndustria.DataBind();



                ddlExperienciaPago.DataSource = rsCatalogos.ListadoGradoRiesgo();
                ddlExperienciaPago.DataTextField = "vchInterface";
                ddlExperienciaPago.DataValueField = "intInterfaceid";
                ddlExperienciaPago.DataBind();

            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }

        }


        public InterfacesServicePersonas.clsDatosPersona ObtieneDatos()
        {

            try
            {
                InterfacesServicePersonas.clsDatosPersona clsPersona = new InterfacesServicePersonas.clsDatosPersona();

                clsPersona.intPersonaID = int.Parse(ViewState["intPersonaID"].ToString());
                clsPersona.strNegocio = Session["negocio"].ToString();
                clsPersona.shExperienciaPagoID = short.Parse(ddlExperienciaPago.SelectedValue);
                clsPersona.strFolioConsultaBuro = txtFolioConsultaBuro.Text;
                clsPersona.decIngresosBrutos = decimal.Parse(txtIngresosBrutos.Text.Replace(",", ""));
                clsPersona.strNombreCNBV = txtNombreCNBVCred.Text;
                clsPersona.shRelacionAcreditado = short.Parse(ddlRelacionAcreditado.SelectedValue);
                clsPersona.shSectorLaboral = short.Parse(ddlSectorLaboral.SelectedValue);
                clsPersona.shComprobanteIngresos = short.Parse(ddlComprobanteIngresos.SelectedValue);
                clsPersona.strFechaConsultaBuro = txtFechaConsultaBuro.Text.Split('/')[2] + txtFechaConsultaBuro.Text.Split('/')[1] + txtFechaConsultaBuro.Text.Split('/')[0];
                clsPersona.shRiesgoFinancieroID = short.Parse(ddlRiesgoFinanciero.SelectedValue);
                clsPersona.shRiesgoIndustriaID = short.Parse(ddlRiesgoIndustria.SelectedValue);
                clsPersona.shTipoAcreditadoRelacionadoID = short.Parse(ddlTipoAcreditadoRelacionado.SelectedValue);
                clsPersona.shTamanoDeudorID = short.Parse(ddlTamanioDeudor.SelectedValue);
                return clsPersona;
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }

        }
    }
}