﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace bajaWare.UserControl.Comun
{
    public partial class wucDomicilio : System.Web.UI.UserControl
    {

        //Evento delegate para mantener el modal
        public delegate void getRegistroEventHandler();
        public event getRegistroEventHandler getRegistroEvent;


        public InterfacesServicesCatalogos.IinterfacesServicesCatalogos rsCatalogos = new InterfacesServicesCatalogos.IinterfacesServicesCatalogosClient();




        protected void Page_Load(object sender, EventArgs e)
        {

        }


        /// <summary>
        /// Carga los datos en el User Conrtrol
        /// </summary>
        /// <param name="clsDatDomicilio">Entidad : bajaWare.InterfacesServicePersonas.clsDomicilio</param>
        public void CargaDatos(bajaWare.InterfacesServicePersonas.clsDomicilio clsDatDomicilio)
        {
            try
            {
                CargaControlesInicialesDomicilio();

                hdnDomicilioID.Value = clsDatDomicilio.intDomicilioID.ToString();

                ddlPais.SelectedValue = clsDatDomicilio.intPais.ToString() == "0" ? "149" : clsDatDomicilio.intPais.ToString();
                ddlEstado.SelectedValue = clsDatDomicilio.intEstado.ToString();

                ddlEstado_OnSelectedIndexChanged(null, null);


                if (clsDatDomicilio.intDelegMpo != 0)
                    ddlMunicipio.SelectedValue = clsDatDomicilio.intDelegMpo.ToString();

                if (clsDatDomicilio.shLocalidad != 0)
                    ddlLocalidad.SelectedValue = clsDatDomicilio.shLocalidad.ToString();

                if (clsDatDomicilio.shTipoDomicilio != 0)
                    ddlTipoDomicilio.SelectedValue = clsDatDomicilio.shTipoDomicilio.ToString();
                else
                    ddlTipoDomicilio.SelectedValue = Session["negocio"].ToString() == "E" ? "2" : "1";



                txtCalle.Text = clsDatDomicilio.strCalle;
                txtCP.Text = clsDatDomicilio.strCodigoPostal;
                txtCP_OnTextChanged(null, null);

                try
                {
                    ddlColonia.SelectedValue = clsDatDomicilio.strColonia;
                }
                catch
                {
                }

                txtNumExt.Text = clsDatDomicilio.strNumExterior;
                txtNumInterior.Text = clsDatDomicilio.strNumInterior;
            }
            catch (Exception ex)
            {
                throw new Exception();
            }

        }

        public bajaWare.InterfacesServicePersonas.clsDomicilio ObtieneDatosDomicilio()
        {
            try
            {
                bajaWare.InterfacesServicePersonas.clsDomicilio clsDom = new InterfacesServicePersonas.clsDomicilio();

                clsDom.intDomicilioID = int.Parse(hdnDomicilioID.Value == "" ? "0" : hdnDomicilioID.Value);
                clsDom.intPais = int.Parse(ddlPais.SelectedValue);
                clsDom.intEstado = int.Parse(ddlEstado.SelectedValue);
                clsDom.strEstado = ddlEstado.Items[ddlEstado.SelectedIndex].Text;
                clsDom.intDelegMpo = int.Parse(ddlMunicipio.SelectedValue);
                clsDom.strMunicipio = ddlMunicipio.Items[ddlMunicipio.SelectedIndex].Text;
                clsDom.shLocalidad = short.Parse(ddlLocalidad.SelectedValue);
                clsDom.strCalle = txtCalle.Text;
                clsDom.strCodigoPostal = txtCP.Text;
                clsDom.strColonia = ddlColonia.SelectedValue;
                clsDom.strNumExterior = txtNumExt.Text;
                clsDom.strNumInterior = txtNumInterior.Text;
                clsDom.shTipoDomicilio = short.Parse(ddlTipoDomicilio.SelectedValue);

                return clsDom;
            }
            catch (Exception ex)
            {
                throw new Exception();
            }
        }

        /// <summary>
        /// Limpia los controles del User Control
        /// </summary>
        private void CargaControlesInicialesDomicilio()
        {
            try
            {
                hdnDomicilioID.Value = "";
                ddlPais.DataSource = rsCatalogos.ListadoPaises();
                ddlPais.DataTextField = "vchInterface";
                ddlPais.DataValueField = "intInterfaceid";
                ddlPais.DataBind();

                ddlPais.SelectedValue = "149";

                ddlTipoDomicilio.DataSource = rsCatalogos.ListaTipoDomicilio();
                ddlTipoDomicilio.DataTextField = "vchInterface";
                ddlTipoDomicilio.DataValueField = "intInterfaceid";
                ddlTipoDomicilio.DataBind();


                ddlEstado.DataSource = rsCatalogos.ListaEstados();
                ddlEstado.DataTextField = "vchInterface";
                ddlEstado.DataValueField = "intInterfaceid";
                ddlEstado.DataBind();

                //ddlLocalidad.DataSource = "";
                //ddlLocalidad.DataBind();

                //ddlColonia.DataSource = "";
                //ddlColonia.DataBind();

                //txtCP.Text = "";
                //txtCalle.Text = "";
                //txtNumExt.Text = "";
                //txtNumInterior.Text = "";

            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }
        }

        /// <summary>
        /// Obtiene los municipios y localidades
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void ddlEstado_OnSelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                ddlMunicipio.DataSource = rsCatalogos.ListaMunicipios(short.Parse(ddlEstado.SelectedValue));
                ddlMunicipio.DataTextField = "vchInterface";
                ddlMunicipio.DataValueField = "intInterfaceid";
                ddlMunicipio.DataBind();

                ddlLocalidad.DataSource = rsCatalogos.ListaLocalidades(short.Parse(ddlEstado.SelectedValue));
                ddlLocalidad.DataTextField = "vchInterface";
                ddlLocalidad.DataValueField = "intInterfaceid";
                ddlLocalidad.DataBind();

               

                getRegistroEvent.Invoke();

            }

            catch (Exception ex)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "Error", "javascript:alert('ERROR AL OBTENER LOS MUNICIPIOS Y/O LOCALIDADES');", true);
            }
        }

        /// <summary>
        /// Obtiene las colonias por el codigo postal
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void txtCP_OnTextChanged(object sender, EventArgs e)
        {
            try
            {
                ddlColonia.DataSource = rsCatalogos.ListaColonias(txtCP.Text);
                ddlColonia.DataTextField = "vchInterface";
                ddlColonia.DataValueField = "vchInterface";
                ddlColonia.DataBind();

                InterfacesServicesCatalogos.SepomexResult cls = new InterfacesServicesCatalogos.SepomexResult();

                cls =  rsCatalogos.ObtineEdoMpoPorCP(txtCP.Text);

       

                if (ddlColonia.Items.Count == 1 && txtCP.Text != "")
                {
                    ScriptManager.RegisterStartupScript(this, this.GetType(), "MsjNoExiste", "javascript:alert('No se encontraron colonias con el codio postal " + txtCP.Text + "');", true);
                }

                try
                {
                    getRegistroEvent.Invoke();

                }
                catch { }

                try
                {
                    ddlEstado.SelectedValue = cls.strEstado;
                    ddlEstado_OnSelectedIndexChanged(null, null);
                    ddlMunicipio.SelectedValue = cls.strMunicipio;
                }
                catch
                {

                }

            }
            catch (Exception ex)
            {
                ScriptManager.RegisterStartupScript(this, this.GetType(), "Error", "javascript:alert('ERROR AL OBTENER LAS COLONIAS');", true);
            }
        }

        protected void btnBuscaColonia_OnClick(object sender, EventArgs e)
        {
            txtCP_OnTextChanged(null, null);
        }


    }
}