﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace bajaWare.UserControl.Comun
{
    public partial class wucPersona : System.Web.UI.UserControl
    {


        public InterfacesServicesCatalogos.IinterfacesServicesCatalogos rsCatalogos = new InterfacesServicesCatalogos.IinterfacesServicesCatalogosClient();


        public InterfacesServicePersonas.IinterfacesServicePersonas rsDatosPersona = new InterfacesServicePersonas.IinterfacesServicePersonasClient();


        private int intPersonaID
        {
            get
            {
                if (ViewState["intPersonaID"] == null)
                    return 0;
                else
                    return (int)ViewState["intPersonaID"];
            }
            set { ViewState.Add("intPersonaID", value); }
        }



        protected void Page_Load(object sender, EventArgs e)
        {

        }


        protected void ddlFisicaMoral_OnSelectedIndexChanged(object sender, EventArgs e)
        {
            if (ddlFisicaMoral.SelectedValue == "2")
            {
                tdApMaterno.Visible = false;
                tdApMaternoText.Visible = false;
                tdApPaterno.Visible = false;
                tdApPaternoText.Visible = false;
            }
            else
            {
                tdApMaterno.Visible = true;
                tdApMaternoText.Visible = true;
                tdApPaterno.Visible = true;
                tdApPaternoText.Visible = true;
            }
        }


        public InterfacesServicePersonas.clsDatosPersona ObtieneDatosPersona()
        {
            try
            {

                InterfacesServicePersonas.clsDatosPersona cls = new InterfacesServicePersonas.clsDatosPersona();

                cls.strNombre = txtNombre.Text;
                cls.strApPaterno = txtApPaterno.Text;
                cls.strApMaterno = txtApMaterno.Text;
                cls.strRFC = txtRFC.Text;
                cls.intPersonalidadJuridica = int.Parse(ddlFisicaMoral.SelectedValue);

                return cls;

            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }
        }

        public void CargaDatos(InterfacesServicePersonas.clsDatosPersona clsPersona)
        {
            try
            {
                CargaDatosIniciales();

                intPersonaID = clsPersona.intPersonaID;
                txtNombre.Text = clsPersona.strNombre;
                txtApPaterno.Text = clsPersona.strApPaterno;
                txtApMaterno.Text = clsPersona.strApMaterno;
                txtRFC.Text = clsPersona.strRFC;
                ddlFisicaMoral.SelectedValue = clsPersona.intPersonalidadJuridica.ToString();
                UPD_Persona.Update();
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message);
            }
        }

        public void CargaDatosIniciales()
        {
            ddlFisicaMoral.DataSource = rsCatalogos.ListadoPersonalidadJuridica();
            ddlFisicaMoral.DataTextField = "vchInterface";
            ddlFisicaMoral.DataValueField = "intInterfaceid";

            ddlFisicaMoral.DataBind();

            intPersonaID = 0;
            txtNombre.Text = "";
            txtApPaterno.Text = "";
            txtApMaterno.Text = "";
            txtRFC.Text = "";

            UPD_Persona.Update();
        }

        public void txtRFC_OnTextChanged(object sender, EventArgs e)
        {
            try
            {
                InterfacesServicePersonas.clsDatosPersona cls = null;


                cls = rsDatosPersona.ExistePersona(txtRFC.Text, "");


                if (cls != null)
                    if (cls.intPersonaID != 0)
                    {
                        ScriptManager.RegisterStartupScript(UPD_Persona, typeof(UpdatePanel), "MsjExiste", "javascript:alert('Existe la Persona con el RFC: " + txtRFC.Text + "');", true);
                        CargaDatos(cls);
                    }


            }
            catch (Exception ex)
            {
                ScriptManager.RegisterStartupScript(UPD_Persona, typeof(UpdatePanel), "Error", "javascript:alert('Error al buscar el RFC.');", true);
            }
        }

        public void txtNombre_OnTextChanged(object sender, EventArgs e)
        {
            try
            {
                InterfacesServicePersonas.clsDatosPersona cls = null;

                if (ddlFisicaMoral.SelectedValue == "1")
                {
                    if (txtNombre.Text != "" && txtApPaterno.Text != "" && txtApMaterno.Text != "")
                    {
                        cls = rsDatosPersona.ExistePersona("", txtNombre.Text + txtApPaterno.Text + txtApMaterno.Text);
                    }


                }
                else
                {
                    if (txtNombre.Text != "")
                    {
                        cls = rsDatosPersona.ExistePersona("", txtNombre.Text);
                    }

                }


                if (cls != null)
                    if (cls.intPersonaID != 0)
                    {
                        ScriptManager.RegisterStartupScript(UPD_Persona, typeof(UpdatePanel), "MsjExiste", "javascript:alert('Ya existe la persona.');", true);
                        CargaDatos(cls);
                    }


                if (ddlFisicaMoral.SelectedValue == "1")
                {
                    if (((TextBox)sender).ID == "txtNombre")
                        txtApPaterno.Focus();
                    if (((TextBox)sender).ID == "txtApPaterno")
                        txtApMaterno.Focus();
                }
                else
                {

                    if (((TextBox)sender).ID == "txtNombre")
                        txtRFC.Focus();
                }
            }
            catch (Exception ex)
            {
                ScriptManager.RegisterStartupScript(UPD_Persona, typeof(UpdatePanel), "Error", "javascript:alert('Error al buscar el Nombre.');", true);
            }
        }

    }
}