﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace bajaWare.UserControl.Credito
{
    public partial class wucCredHipotecsCredito : System.Web.UI.UserControl
    {
        public InterfacesServicesCatalogos.IinterfacesServicesCatalogos rsCatalogos = new InterfacesServicesCatalogos.IinterfacesServicesCatalogosClient();
        public InterfaceServiceCreditHipot.IinterfacesServiceCreditHipot rsCreditHipo = new InterfaceServiceCreditHipot.IinterfacesServiceCreditHipotClient();
        public bool? CPvalido { 
            get
            {
                return (bool?)ViewState["CPvalido"];
            }
            set
            {
                ViewState["CPvalido"] = value;
            }
                 }
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                LlenaCombos();
            }
           
        }
        void LlenaCombos()
        {
            ddlDestinoCredito.DataSource = rsCatalogos.ListaDestinoCredito();
            ddlDestinoCredito.DataTextField = "vchInterface";
            ddlDestinoCredito.DataValueField = "intInterfaceid";
            ddlDestinoCredito.DataBind();
            ddlEntidadCofinanciadora.DataSource = rsCatalogos.ListarEntidadCofinanciadora();
            ddlEntidadCofinanciadora.DataTextField = "vchInterface";
            ddlEntidadCofinanciadora.DataValueField = "intInterfaceid";
            ddlEntidadCofinanciadora.DataBind();
            //ddlProductoHipotecario.DataSource = rsCatalogos.ListarProductoHipotecario();
            //ddlProductoHipotecario.DataTextField = "vchInterface";
            //ddlProductoHipotecario.DataValueField = "intInterfaceid";
            //ddlProductoHipotecario.DataBind();
            ddlSectorLaboral.DataSource = rsCatalogos.ListadoSectorLaboral();
            ddlSectorLaboral.DataTextField = "vchInterface";
            ddlSectorLaboral.DataValueField = "intInterfaceid";
            ddlSectorLaboral.DataBind();
            ddlTasaReferencia.DataSource = rsCatalogos.ListaTasaReferencia();
            ddlTasaReferencia.DataTextField = "vchInterface";
            ddlTasaReferencia.DataValueField = "intInterfaceid";
            ddlTasaReferencia.DataBind();
            ddlTipoAlta.DataSource = rsCatalogos.ListaTipoAlta();
            ddlTipoAlta.DataTextField = "vchInterface";
            ddlTipoAlta.DataValueField = "intInterfaceid";
            ddlTipoAlta.DataBind();
            ddlTipoBaja.DataSource = rsCatalogos.ListaTipoBaja();
            ddlTipoBaja.DataTextField = "vchInterface";
            ddlTipoBaja.DataValueField = "intInterfaceid";
            ddlTipoBaja.DataBind();
            ddlTipoCompIngresos.DataSource = rsCatalogos.ListadoComprobanteIngresos();
            ddlTipoCompIngresos.DataTextField = "vchInterface";
            ddlTipoCompIngresos.DataValueField = "intInterfaceid";
            try
            {
                ddlTipoCompIngresos.DataBind();
            }
            catch{
                ddlTipoCompIngresos.SelectedValue = "0";
                ddlTipoCompIngresos.DataBind();
            }
            ddlTipoSeguro.DataSource = rsCatalogos.ListarTipoSeguro();
            ddlTipoSeguro.DataTextField = "vchInterface";
            ddlTipoSeguro.DataValueField = "intInterfaceid";
            ddlTipoSeguro.DataBind();
            ddlTipoTasaInteres.DataSource = rsCatalogos.ListarTipoTasaInteres();
            ddlTipoTasaInteres.DataTextField = "vchInterface";
            ddlTipoTasaInteres.DataValueField = "intInterfaceid";
            ddlTipoTasaInteres.DataBind();
            ddlTipoCreditoR04A.DataSource = rsCatalogos.ListadoTipoCreditoR04A();
            ddlTipoCreditoR04A.DataTextField = "vchInterface";
            ddlTipoCreditoR04A.DataValueField = "intInterfaceid";
            ddlTipoCreditoR04A.DataBind();


        }
        public void CargaInformacion(InterfaceServiceCreditHipot.CreditoHipotecario credHipo)
        {
            ddlDestinoCredito.SelectedValue = credHipo.sintDestinoCredID.ToString();
            ddlEntidadCofinanciadora.SelectedValue = credHipo.sintEntidadCofinanID.ToString();
            //ddlProductoHipotecario.SelectedValue = credHipo.pro.ToString();
            ddlSectorLaboral.SelectedValue = credHipo.tintSectorLabID.ToString();
            ddlTasaReferencia.SelectedValue = credHipo.sintTasaRefID.ToString();
            ddlTipoAlta.SelectedValue = credHipo.tintTipoAltaID.ToString();
            ddlTipoBaja.SelectedValue = credHipo.tintTipoBajaID.ToString();
            ddlTipoCompIngresos.SelectedValue = credHipo.iComprobanteEmpleoId.ToString();
            if(credHipo.tintTipoSeguroID!=null)
                ddlTipoSeguro.SelectedValue = credHipo.tintTipoSeguroID.ToString();
            if (credHipo.tintTipoTasaIntID != null)
            ddlTipoTasaInteres.SelectedValue = credHipo.tintTipoTasaIntID.ToString();
            ddlTipoCreditoR04A.SelectedValue = credHipo.sintTipoCreditoID.ToString();
            txtCP.Text = credHipo.sCodigoPostal;
            txtIngresosAnuales.Text = Convert.ToInt32(credHipo.decImporteIngreso).ToString();

        }
        public void Inserta(InterfaceServiceCreditHipot.CreditoHipotecario credHipo)
        {
            credHipo.sintDestinoCredID = Convert.ToInt16(ddlDestinoCredito.SelectedValue);
            credHipo.sintEntidadCofinanID=Convert.ToInt16(ddlEntidadCofinanciadora.SelectedValue);
            //ddlProductoHipotecario.SelectedValue = credHipo.pro.ToString();
            credHipo.tintSectorLabID = Convert.ToInt16(ddlSectorLaboral.SelectedValue);
            credHipo.sintTasaRefID= Convert.ToInt16(ddlTasaReferencia.SelectedValue);
            credHipo.tintTipoAltaID = Convert.ToInt16(ddlTipoAlta.SelectedValue);
            credHipo.tintTipoBajaID = Convert.ToInt16(ddlTipoBaja.SelectedValue);
            credHipo.iComprobanteEmpleoId = Convert.ToInt16(ddlTipoCompIngresos.SelectedValue);
            credHipo.tintTipoSeguroID=Convert.ToInt16(ddlTipoSeguro.SelectedValue);
            credHipo.tintTipoTasaIntID = Convert.ToInt16(ddlTipoTasaInteres.SelectedValue);
            credHipo.sintTipoCreditoID=Convert.ToInt16(ddlTipoCreditoR04A.SelectedValue);
            credHipo.sCodigoPostal = txtCP.Text;
            credHipo.decImporteIngreso = Convert.ToDecimal(txtIngresosAnuales.Text);
            rsCreditHipo.ActualizaCreditoHipotecario(credHipo);
        }

        protected void txtCP_TextChanged(object sender, EventArgs e)
        {

           InterfaceServiceCreditHipot.clsDomicilio Domicilio= rsCreditHipo.ObtieneEstadoMunicipio(txtCP.Text);
           if (Domicilio.strCodigoPostal != string.Empty)
              CPvalido=true;
           else
               CPvalido = false;
        }
    }
}